/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.util;

import com.opensymphony.xwork.util.CompoundRoot;
import com.opensymphony.xwork.util.CompoundRootAccessor;
import com.opensymphony.xwork.util.InstantiatingNullHandler;
import com.opensymphony.xwork.util.OgnlUtil;
import com.opensymphony.xwork.util.SafeExpressionUtil;
import com.opensymphony.xwork.util.XWorkConverter;
import com.opensymphony.xwork.util.XWorkEnumerationAcccessor;
import com.opensymphony.xwork.util.XWorkIteratorPropertyAccessor;
import com.opensymphony.xwork.util.XWorkMethodAccessor;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import ognl.ClassResolver;
import ognl.MethodAccessor;
import ognl.NullHandler;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import ognl.TypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OgnlValueStack
implements Serializable {
    public static final String VALUE_STACK = "com.opensymphony.xwork.util.OgnlValueStack.ValueStack";
    public static final String REPORT_ERRORS_ON_NO_PROP = "com.opensymphony.xwork.util.OgnlValueStack.ReportErrorsOnNoProp";
    private static CompoundRootAccessor accessor;
    private static Log LOG;
    CompoundRoot root;
    transient Map context;
    transient SafeExpressionUtil safeExpressionUtil;
    Class defaultType;
    Map overrides;

    public OgnlValueStack() {
        this.setRoot(new CompoundRoot());
    }

    public static CompoundRootAccessor getAccessor() {
        return accessor;
    }

    public Map getContext() {
        return this.context;
    }

    public void setDefaultType(Class defaultType) {
        this.defaultType = defaultType;
    }

    public void setExprOverrides(Map overrides) {
        this.overrides = overrides;
    }

    public CompoundRoot getRoot() {
        return this.root;
    }

    public void setValue(String expr, Object value) {
        this.setValue(expr, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String expr, Object value, boolean throwExceptionOnFailure) {
        Map context = this.getContext();
        try {
            context.put("conversion.property.fullName", expr);
            context.put(REPORT_ERRORS_ON_NO_PROP, new Boolean(throwExceptionOnFailure));
            OgnlUtil.setValue(expr, context, this.root, value);
        }
        catch (OgnlException ognlException) {
        }
        finally {
            context.remove("conversion.property.fullName");
            context.remove(REPORT_ERRORS_ON_NO_PROP);
        }
    }

    public Object findValue(String expr) {
        try {
            if (expr == null) {
                return null;
            }
            if (!this.safeExpressionUtil.isSafeExpression(expr)) {
                return null;
            }
            if (this.overrides != null && this.overrides.containsKey(expr)) {
                expr = (String)this.overrides.get(expr);
            }
            if (this.defaultType != null) {
                return this.findValue(expr, this.defaultType);
            }
            return Ognl.getValue((Object)OgnlUtil.compile(expr), (Map)this.context, (Object)this.root);
        }
        catch (OgnlException e) {
            return null;
        }
        catch (Exception e) {
            LOG.warn((Object)("Caught an exception while evaluating expression '" + expr + "' against value stack"), (Throwable)e);
            return null;
        }
    }

    public Object findValue(String expr, Class asType) {
        try {
            if (expr == null) {
                return null;
            }
            if (!this.safeExpressionUtil.isSafeExpression(expr)) {
                return null;
            }
            if (this.overrides != null && this.overrides.containsKey(expr)) {
                expr = (String)this.overrides.get(expr);
            }
            return Ognl.getValue((Object)OgnlUtil.compile(expr), (Map)this.context, (Object)this.root, (Class)asType);
        }
        catch (OgnlException e) {
            return null;
        }
        catch (Exception e) {
            LOG.warn((Object)("Caught an exception while evaluating expression '" + expr + "' against value stack"), (Throwable)e);
            return null;
        }
    }

    public Object peek() {
        return this.root.peek();
    }

    public Object pop() {
        return this.root.pop();
    }

    public void push(Object o) {
        this.root.push(o);
    }

    public int size() {
        return this.root.size();
    }

    private void setRoot(CompoundRoot compoundRoot) {
        this.root = compoundRoot;
        this.context = Ognl.createDefaultContext((Object)this.root, (ClassResolver)accessor, (TypeConverter)XWorkConverter.getInstance());
        this.safeExpressionUtil = new SafeExpressionUtil();
        this.context.put(VALUE_STACK, this);
        Ognl.setClassResolver((Map)this.context, (ClassResolver)accessor);
        ((OgnlContext)this.context).setTraceEvaluations(true);
        ((OgnlContext)this.context).setKeepLastEvaluation(true);
    }

    private Object readResolve() {
        OgnlValueStack aStack = new OgnlValueStack();
        aStack.setRoot(this.root);
        return aStack;
    }

    static {
        LOG = LogFactory.getLog(OgnlValueStack.class);
        accessor = new CompoundRootAccessor();
        OgnlRuntime.setPropertyAccessor(CompoundRoot.class, (PropertyAccessor)accessor);
        OgnlRuntime.setPropertyAccessor(Iterator.class, (PropertyAccessor)new XWorkIteratorPropertyAccessor());
        OgnlRuntime.setPropertyAccessor(Enumeration.class, (PropertyAccessor)new XWorkEnumerationAcccessor());
        OgnlRuntime.setMethodAccessor(Object.class, (MethodAccessor)new XWorkMethodAccessor());
        OgnlRuntime.setMethodAccessor(CompoundRoot.class, (MethodAccessor)accessor);
        OgnlRuntime.setNullHandler(Object.class, (NullHandler)new InstantiatingNullHandler());
    }
}

