/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.util;

import com.opensymphony.xwork.Action;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.ModelDriven;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.opensymphony.xwork.util.TextParseUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalizedTextUtil {
    private static final List DEFAULT_RESOURCE_BUNDLES = Collections.synchronizedList(new ArrayList());
    private static final Log LOG = LogFactory.getLog(LocalizedTextUtil.class);
    private static boolean reloadBundles = false;

    public static void setReloadBundles(boolean reloadBundles) {
        LocalizedTextUtil.reloadBundles = reloadBundles;
    }

    public static void addDefaultResourceBundle(String resourceBundleName) {
        DEFAULT_RESOURCE_BUNDLES.remove(resourceBundleName);
        DEFAULT_RESOURCE_BUNDLES.add(0, resourceBundleName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Added default resource bundle " + resourceBundleName + ", default resource bundles = " + DEFAULT_RESOURCE_BUNDLES));
        }
    }

    public static String findDefaultText(String aTextName, Locale locale) throws MissingResourceException {
        MissingResourceException e = null;
        ArrayList localList = new ArrayList(DEFAULT_RESOURCE_BUNDLES);
        for (String bundleName : localList) {
            try {
                ResourceBundle bundle = LocalizedTextUtil.findResourceBundle(bundleName, locale);
                LocalizedTextUtil.reloadBundles(bundle);
                return bundle.getString(aTextName);
            }
            catch (MissingResourceException ex) {
                e = ex;
            }
        }
        if (e == null) {
            e = new MissingResourceException("Unable to find text for key " + aTextName, LocalizedTextUtil.class.getName(), aTextName);
        }
        throw e;
    }

    public static String findDefaultText(String aTextName, Locale locale, Object[] params) throws MissingResourceException {
        MessageFormat mf = LocalizedTextUtil.buildMessageFormat(LocalizedTextUtil.findDefaultText(aTextName, locale), locale);
        return mf.format(params);
    }

    public static ResourceBundle findResourceBundle(String aBundleName, Locale locale) {
        return ResourceBundle.getBundle(aBundleName, locale, Thread.currentThread().getContextClassLoader());
    }

    public static String findText(Class aClass, String aTextName, Locale locale) {
        return LocalizedTextUtil.findText(aClass, aTextName, locale, aTextName, new Object[0]);
    }

    public static String findText(Class aClass, String aTextName, Locale locale, String defaultMessage, Object[] args) {
        Action action;
        ActionInvocation actionInvocation;
        String msg;
        ActionContext context = ActionContext.getContext();
        OgnlValueStack valueStack = context.getValueStack();
        String indexedTextName = null;
        if (aTextName.indexOf("[") != -1) {
            int i = -1;
            indexedTextName = aTextName;
            while ((i = indexedTextName.indexOf("[", i + 1)) != -1) {
                int j = indexedTextName.indexOf("]", i);
                String a = indexedTextName.substring(0, i);
                String b = indexedTextName.substring(j);
                indexedTextName = a + "[*" + b;
            }
        }
        if ((msg = LocalizedTextUtil.findMessage(aClass, aTextName, indexedTextName, locale, args, null, valueStack)) != null) {
            return msg;
        }
        if (ModelDriven.class.isAssignableFrom(aClass) && (actionInvocation = context.getActionInvocation()) != null && (msg = LocalizedTextUtil.findMessage(((ModelDriven)((Object)(action = actionInvocation.getAction()))).getModel().getClass(), aTextName, indexedTextName, locale, args, null, valueStack)) != null) {
            return msg;
        }
        for (Class clazz = aClass; clazz != null && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            if (clazz.getPackage() == null) continue;
            String packageName = clazz.getPackage().getName() + ".package";
            msg = LocalizedTextUtil.getMessage(packageName, locale, aTextName, valueStack, args);
            if (msg != null) {
                return msg;
            }
            if (indexedTextName == null || (msg = LocalizedTextUtil.getMessage(packageName, locale, indexedTextName, valueStack, args)) == null) continue;
            return msg;
        }
        int idx = aTextName.indexOf(".");
        if (idx != -1) {
            Class<?> clazz;
            Object obj;
            String newKey = null;
            String prop = null;
            if (aTextName.startsWith("invalid.fieldvalue.")) {
                idx = aTextName.indexOf(".", "invalid.fieldvalue.".length());
                if (idx != -1) {
                    prop = aTextName.substring("invalid.fieldvalue.".length(), idx);
                    newKey = "invalid.fieldvalue." + aTextName.substring(idx + 1);
                }
            } else {
                prop = aTextName.substring(0, idx);
                newKey = aTextName.substring(idx + 1);
            }
            if (prop != null && (obj = valueStack.findValue(prop)) != null && (clazz = obj.getClass()) != null) {
                valueStack.push(obj);
                msg = LocalizedTextUtil.findText(clazz, newKey, locale, null, args);
                valueStack.pop();
                if (msg != null) {
                    return msg;
                }
            }
        }
        if (indexedTextName == null) {
            return LocalizedTextUtil.getDefaultMessage(aTextName, locale, valueStack, args, defaultMessage);
        }
        msg = LocalizedTextUtil.getDefaultMessage(aTextName, locale, valueStack, args, null);
        if (msg != null) {
            return msg;
        }
        return LocalizedTextUtil.getDefaultMessage(indexedTextName, locale, valueStack, args, defaultMessage);
    }

    public static String findText(ResourceBundle bundle, String aTextName, Locale locale) {
        return LocalizedTextUtil.findText(bundle, aTextName, locale, aTextName, new Object[0]);
    }

    public static String findText(ResourceBundle bundle, String aTextName, Locale locale, String defaultMessage, Object[] args) {
        OgnlValueStack valueStack = ActionContext.getContext().getValueStack();
        try {
            LocalizedTextUtil.reloadBundles(bundle);
            String message = TextParseUtil.translateVariables(bundle.getString(aTextName), valueStack);
            MessageFormat mf = LocalizedTextUtil.buildMessageFormat(message, locale);
            return mf.format(args);
        }
        catch (MissingResourceException missingResourceException) {
            return LocalizedTextUtil.getDefaultMessage(aTextName, locale, valueStack, args, defaultMessage);
        }
    }

    private static String getDefaultMessage(String key, Locale locale, OgnlValueStack valueStack, Object[] args, String defaultMessage) {
        if (key != null) {
            String message = null;
            try {
                message = LocalizedTextUtil.findDefaultText(key, locale);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (message == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Unable to find text for key " + key));
                }
                message = defaultMessage;
            }
            if (message != null) {
                MessageFormat mf = LocalizedTextUtil.buildMessageFormat(TextParseUtil.translateVariables(message, valueStack), locale);
                return mf.format(args);
            }
        }
        return null;
    }

    private static String getMessage(String bundleName, Locale locale, String key, OgnlValueStack valueStack, Object[] args) {
        try {
            ResourceBundle bundle = LocalizedTextUtil.findResourceBundle(bundleName, locale);
            LocalizedTextUtil.reloadBundles(bundle);
            String message = TextParseUtil.translateVariables(bundle.getString(key), valueStack);
            MessageFormat mf = LocalizedTextUtil.buildMessageFormat(message, locale);
            return mf.format(args);
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    private static MessageFormat buildMessageFormat(String pattern, Locale locale) {
        MessageFormat format = new MessageFormat("");
        format.setLocale(locale);
        format.applyPattern(pattern);
        return format;
    }

    private static String findMessage(Class clazz, String key, String indexedKey, Locale locale, Object[] args, Set checked, OgnlValueStack valueStack) {
        int x;
        if (checked == null) {
            checked = new TreeSet();
        } else if (checked.contains(clazz.getName())) {
            return null;
        }
        String msg = LocalizedTextUtil.getMessage(clazz.getName(), locale, key, valueStack, args);
        if (msg != null) {
            return msg;
        }
        if (indexedKey != null && (msg = LocalizedTextUtil.getMessage(clazz.getName(), locale, indexedKey, valueStack, args)) != null) {
            return msg;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (x = 0; x < interfaces.length; ++x) {
            msg = LocalizedTextUtil.getMessage(interfaces[x].getName(), locale, key, valueStack, args);
            if (msg != null) {
                return msg;
            }
            if (indexedKey == null || (msg = LocalizedTextUtil.getMessage(interfaces[x].getName(), locale, indexedKey, valueStack, args)) == null) continue;
            return msg;
        }
        if (clazz.isInterface()) {
            interfaces = clazz.getInterfaces();
            for (x = 0; x < interfaces.length; ++x) {
                msg = LocalizedTextUtil.findMessage(interfaces[x], key, indexedKey, locale, args, checked, valueStack);
                if (msg == null) continue;
                return msg;
            }
        } else if (!clazz.equals(Object.class)) {
            return LocalizedTextUtil.findMessage(clazz.getSuperclass(), key, indexedKey, locale, args, checked, valueStack);
        }
        return null;
    }

    private static void reloadBundles(ResourceBundle resource) {
        if (reloadBundles) {
            try {
                Class<?> klass = resource.getClass().getSuperclass();
                Field field = klass.getDeclaredField("cacheList");
                field.setAccessible(true);
                Object cache = field.get(null);
                Method clearMethod = cache.getClass().getMethod("clear", new Class[0]);
                clearMethod.invoke(cache, new Object[0]);
            }
            catch (Exception e) {
                LOG.error((Object)"Could not reload resource bundles", (Throwable)e);
            }
        }
    }

    static {
        DEFAULT_RESOURCE_BUNDLES.add("com/opensymphony/xwork/xwork-messages");
    }
}

