/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.interceptor;

import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.Interceptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimerInterceptor
implements Interceptor {
    private static final Log log = LogFactory.getLog(TimerInterceptor.class);

    @Override
    public void destroy() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof TimerInterceptor;
    }

    public int hashCode() {
        return 10;
    }

    @Override
    public void init() {
    }

    @Override
    public String intercept(ActionInvocation invocation) throws Exception {
        if (log.isInfoEnabled()) {
            long startTime = System.currentTimeMillis();
            String result = invocation.invoke();
            long executionTime = System.currentTimeMillis() - startTime;
            String namespace = invocation.getProxy().getNamespace();
            StringBuffer message = new StringBuffer("Processed action ");
            if (namespace != null && namespace.trim().length() > 0) {
                message.append(namespace).append("/");
            }
            message.append(invocation.getProxy().getActionName());
            message.append(" in ").append(executionTime).append("ms.");
            log.info((Object)message.toString());
            return result;
        }
        return invocation.invoke();
    }
}

