/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.interceptor;

import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.ValidationAware;
import com.opensymphony.xwork.interceptor.Interceptor;
import com.opensymphony.xwork.interceptor.PreResultListener;
import com.opensymphony.xwork.util.XWorkConverter;
import java.util.HashMap;
import java.util.Map;

public class ConversionErrorInterceptor
implements Interceptor {
    @Override
    public void destroy() {
    }

    @Override
    public void init() {
    }

    @Override
    public String intercept(ActionInvocation invocation) throws Exception {
        ActionContext invocationContext = invocation.getInvocationContext();
        Map conversionErrors = invocationContext.getConversionErrors();
        ValidationAware action = null;
        if (invocation.getAction() instanceof ValidationAware) {
            action = (ValidationAware)((Object)invocation.getAction());
        }
        final HashMap<String, String> filteredConversionErrors = new HashMap<String, String>();
        for (Map.Entry entry : conversionErrors.entrySet()) {
            String propertyName = (String)entry.getKey();
            String value = ConversionErrorInterceptor.getStringValue(entry.getValue());
            if (value == null || value.isEmpty()) continue;
            filteredConversionErrors.put(propertyName, value);
            if (action == null) continue;
            String message = XWorkConverter.getConversionErrorMessage(propertyName, invocationContext.getValueStack());
            action.addFieldError(propertyName, message);
        }
        invocation.addPreResultListener(new PreResultListener(){

            @Override
            public void beforeResult(ActionInvocation invocation, String resultCode) {
                if (invocation.getStack() != null && invocation.getStack().getContext() != null) {
                    Map map = invocation.getStack().getContext();
                    map.putAll(filteredConversionErrors);
                }
            }
        });
        return invocation.invoke();
    }

    private static String getStringValue(Object o) {
        if (o instanceof String[]) {
            String[] strings = (String[])o;
            if (strings.length > 0) {
                return strings[0];
            }
            return null;
        }
        return o != null ? o.toString() : "";
    }
}

