/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.config.providers;

import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.config.ConfigurationException;
import com.opensymphony.xwork.config.entities.InterceptorConfig;
import com.opensymphony.xwork.config.entities.InterceptorStackConfig;
import com.opensymphony.xwork.config.entities.PackageConfig;
import com.opensymphony.xwork.interceptor.Interceptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InterceptorBuilder {
    private static final Log LOG = LogFactory.getLog(InterceptorBuilder.class);

    public static List constructInterceptorReference(PackageConfig packageConfig, String refName, Map refParams) throws ConfigurationException {
        Object referencedConfig = packageConfig.getAllInterceptorConfigs().get(refName);
        ArrayList<Interceptor> result = new ArrayList<Interceptor>();
        if (referencedConfig == null) {
            LOG.error((Object)("Unable to find interceptor class referenced by ref-name " + refName));
        } else if (referencedConfig instanceof InterceptorConfig) {
            result.add(ObjectFactory.getObjectFactory().buildInterceptor((InterceptorConfig)referencedConfig, refParams));
        } else if (referencedConfig instanceof InterceptorStackConfig) {
            InterceptorStackConfig stackConfig = (InterceptorStackConfig)referencedConfig;
            if (refParams != null && refParams.size() > 0) {
                LOG.warn((Object)("Interceptor-ref params are being ignored because they are applied to an Interceptor-Stack reference. Ref name = " + refName + ", params = " + refParams));
            }
            result.addAll(stackConfig.getInterceptors());
        } else {
            LOG.error((Object)("Got unexpected type for interceptor " + refName + ". Got " + referencedConfig));
        }
        return result;
    }
}

