/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.config.impl;

import com.opensymphony.xwork.config.Configuration;
import com.opensymphony.xwork.config.ConfigurationException;
import com.opensymphony.xwork.config.ConfigurationManager;
import com.opensymphony.xwork.config.ConfigurationProvider;
import com.opensymphony.xwork.config.RuntimeConfiguration;
import com.opensymphony.xwork.config.entities.ActionConfig;
import com.opensymphony.xwork.config.entities.PackageConfig;
import com.opensymphony.xwork.config.entities.ResultTypeConfig;
import com.opensymphony.xwork.config.providers.InterceptorBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultConfiguration
implements Configuration {
    protected static final Log LOG = LogFactory.getLog(DefaultConfiguration.class);
    private Map packageContexts = new HashMap();
    private RuntimeConfiguration runtimeConfiguration;
    private Set<String> excludedClasses = Collections.unmodifiableSet(new HashSet());
    private Set<String> excludedPackageNames = Collections.unmodifiableSet(new HashSet());
    private Set<String> allowedClasses = Collections.unmodifiableSet(new HashSet());

    @Override
    public PackageConfig getPackageConfig(String name) {
        return (PackageConfig)this.packageContexts.get(name);
    }

    @Override
    public Set getPackageConfigNames() {
        return this.packageContexts.keySet();
    }

    @Override
    public Map getPackageConfigs() {
        return this.packageContexts;
    }

    @Override
    public RuntimeConfiguration getRuntimeConfiguration() {
        return this.runtimeConfiguration;
    }

    @Override
    public void addPackageConfig(String name, PackageConfig packageContext) {
        this.packageContexts.put(name, packageContext);
    }

    @Override
    public void addExcludedClasses(Set<String> newExcludedClasses) {
        HashSet<String> excludedClasses = new HashSet<String>();
        excludedClasses.addAll(this.excludedClasses);
        excludedClasses.addAll(newExcludedClasses);
        this.excludedClasses = Collections.unmodifiableSet(excludedClasses);
    }

    @Override
    public void addExcludedPackageNames(Set<String> newExcludedPackageNames) {
        HashSet<String> excludedPackageNames = new HashSet<String>();
        excludedPackageNames.addAll(this.excludedPackageNames);
        excludedPackageNames.addAll(newExcludedPackageNames);
        this.excludedPackageNames = Collections.unmodifiableSet(excludedPackageNames);
    }

    @Override
    public void addAllowedClasses(Set<String> newAllowedClasses) {
        HashSet<String> allowedClasses = new HashSet<String>();
        allowedClasses.addAll(this.allowedClasses);
        allowedClasses.addAll(newAllowedClasses);
        this.allowedClasses = Collections.unmodifiableSet(allowedClasses);
    }

    @Override
    public Set<String> getExcludedClasses() {
        return this.excludedClasses;
    }

    @Override
    public Set<String> getExcludedPackageNames() {
        return this.excludedPackageNames;
    }

    @Override
    public Set<String> getAllowedClasses() {
        return this.allowedClasses;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void rebuildRuntimeConfiguration() {
        this.runtimeConfiguration = this.buildRuntimeConfiguration();
    }

    @Override
    public synchronized void reload() throws ConfigurationException {
        this.packageContexts.clear();
        for (ConfigurationProvider provider : ConfigurationManager.getConfigurationProviders()) {
            provider.init(this);
        }
        this.rebuildRuntimeConfiguration();
    }

    @Override
    public void removePackageConfig(String name) {
        PackageConfig toBeRemoved = (PackageConfig)this.packageContexts.get(name);
        if (toBeRemoved != null) {
            for (PackageConfig packageContext : this.packageContexts.values()) {
                packageContext.removeParent(toBeRemoved);
            }
        }
    }

    protected synchronized RuntimeConfiguration buildRuntimeConfiguration() throws ConfigurationException {
        HashMap namespaceActionConfigs = new HashMap();
        for (PackageConfig packageContext : this.packageContexts.values()) {
            if (packageContext.isAbstract()) continue;
            String namespace = packageContext.getNamespace();
            HashMap<String, ActionConfig> configs = (HashMap<String, ActionConfig>)namespaceActionConfigs.get(namespace);
            if (configs == null) {
                configs = new HashMap<String, ActionConfig>();
            }
            Map actionConfigs = packageContext.getAllActionConfigs();
            for (String actionName : actionConfigs.keySet()) {
                ActionConfig baseConfig = (ActionConfig)actionConfigs.get(actionName);
                configs.put(actionName, this.buildFullActionConfig(packageContext, baseConfig));
            }
            namespaceActionConfigs.put(namespace, configs);
        }
        return new RuntimeConfigurationImpl(namespaceActionConfigs);
    }

    private void setDefaultResults(Map results, PackageConfig packageContext) {
        String defaultResult = packageContext.getFullDefaultResultType();
        for (Map.Entry entry : results.entrySet()) {
            if (entry.getValue() != null) continue;
            ResultTypeConfig resultTypeConfig = (ResultTypeConfig)packageContext.getAllResultTypeConfigs().get(defaultResult);
            entry.setValue(resultTypeConfig.getClazz());
        }
    }

    private ActionConfig buildFullActionConfig(PackageConfig packageContext, ActionConfig baseConfig) throws ConfigurationException {
        String defaultInterceptorRefName;
        HashMap params = new HashMap(baseConfig.getParams());
        HashMap results = new HashMap(packageContext.getAllGlobalResults());
        results.putAll(baseConfig.getResults());
        this.setDefaultResults(results, packageContext);
        ArrayList interceptors = new ArrayList(baseConfig.getInterceptors());
        if (interceptors.size() <= 0 && (defaultInterceptorRefName = packageContext.getFullDefaultInterceptorRef()) != null) {
            interceptors.addAll(InterceptorBuilder.constructInterceptorReference(packageContext, defaultInterceptorRefName, new HashMap()));
        }
        List externalRefs = baseConfig.getExternalRefs();
        ActionConfig config = new ActionConfig(baseConfig.getMethodName(), baseConfig.getClassName(), params, results, interceptors, externalRefs, packageContext.getName());
        return config;
    }

    private class RuntimeConfigurationImpl
    implements RuntimeConfiguration {
        private Map namespaceActionConfigs;

        public RuntimeConfigurationImpl(Map namespaceActionConfigs) {
            this.namespaceActionConfigs = namespaceActionConfigs;
        }

        @Override
        public synchronized ActionConfig getActionConfig(String namespace, String name) {
            ActionConfig config = null;
            Map actions = (Map)this.namespaceActionConfigs.get(namespace == null ? "" : namespace);
            if (actions != null) {
                config = (ActionConfig)actions.get(name);
            }
            if (config == null && namespace != null && !namespace.trim().equals("") && (actions = (Map)this.namespaceActionConfigs.get("")) != null) {
                config = (ActionConfig)actions.get(name);
            }
            return config;
        }

        @Override
        public synchronized Map getActionConfigs() {
            return this.namespaceActionConfigs;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer("RuntimeConfiguration - actions are\n");
            for (String namespace : this.namespaceActionConfigs.keySet()) {
                Map actionConfigs = (Map)this.namespaceActionConfigs.get(namespace);
                Iterator iterator2 = actionConfigs.keySet().iterator();
                while (iterator2.hasNext()) {
                    buff.append(namespace + "/" + iterator2.next() + "\n");
                }
            }
            return buff.toString();
        }
    }
}

