/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.config.entities;

import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.config.ExternalReferenceResolver;
import com.opensymphony.xwork.config.entities.ActionConfig;
import com.opensymphony.xwork.config.entities.InterceptorConfig;
import com.opensymphony.xwork.config.entities.InterceptorStackConfig;
import com.opensymphony.xwork.config.entities.ResultConfig;
import com.opensymphony.xwork.config.entities.ResultTypeConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PackageConfig {
    private static final Log LOG = LogFactory.getLog(PackageConfig.class);
    private ExternalReferenceResolver externalRefResolver = null;
    private Map actionConfigs = new HashMap();
    private Map globalResultConfigs = new HashMap();
    private Map interceptorConfigs = new HashMap();
    private Map resultTypeConfigs = new HashMap();
    private Set parents = new HashSet();
    private String defaultInterceptorRef;
    private String defaultResultType;
    private String name;
    private String namespace = "";
    private boolean isAbstract = false;

    public PackageConfig() {
    }

    public PackageConfig(String name) {
        this.name = name;
    }

    public PackageConfig(String name, String namespace, boolean isAbstract, ExternalReferenceResolver externalRefResolver) {
        this(name);
        this.namespace = TextUtils.noNull((String)namespace);
        this.isAbstract = isAbstract;
        this.externalRefResolver = externalRefResolver;
    }

    public PackageConfig(String name, String namespace, boolean isAbstract, ExternalReferenceResolver externalRefResolver, List parents) {
        this(name, namespace, isAbstract, externalRefResolver);
        for (PackageConfig parent : parents) {
            this.addParent(parent);
        }
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public Map getActionConfigs() {
        return this.actionConfigs;
    }

    public Map getAllActionConfigs() {
        HashMap retMap = new HashMap();
        if (!this.parents.isEmpty()) {
            for (PackageConfig parentContext : this.parents) {
                retMap.putAll(parentContext.getAllActionConfigs());
            }
        }
        retMap.putAll(this.getActionConfigs());
        return retMap;
    }

    public Map getAllGlobalResults() {
        HashMap retMap = new HashMap();
        if (!this.parents.isEmpty()) {
            for (PackageConfig parentContext : this.parents) {
                retMap.putAll(parentContext.getAllGlobalResults());
            }
        }
        retMap.putAll(this.getGlobalResultConfigs());
        return retMap;
    }

    public Map getAllInterceptorConfigs() {
        HashMap retMap = new HashMap();
        if (!this.parents.isEmpty()) {
            for (PackageConfig parentContext : this.parents) {
                retMap.putAll(parentContext.getAllInterceptorConfigs());
            }
        }
        retMap.putAll(this.getInterceptorConfigs());
        return retMap;
    }

    public Map getAllResultTypeConfigs() {
        HashMap retMap = new HashMap();
        if (!this.parents.isEmpty()) {
            for (PackageConfig parentContext : this.parents) {
                retMap.putAll(parentContext.getAllResultTypeConfigs());
            }
        }
        retMap.putAll(this.getResultTypeConfigs());
        return retMap;
    }

    public void setDefaultInterceptorRef(String name) {
        this.defaultInterceptorRef = name;
    }

    public String getDefaultInterceptorRef() {
        return this.defaultInterceptorRef;
    }

    public void setDefaultResultType(String defaultResultType) {
        this.defaultResultType = defaultResultType;
    }

    public String getDefaultResultType() {
        return this.defaultResultType;
    }

    public void setExternalRefResolver(ExternalReferenceResolver externalRefResolver) {
        this.externalRefResolver = externalRefResolver;
    }

    public ExternalReferenceResolver getExternalRefResolver() {
        if (this.externalRefResolver == null) {
            for (PackageConfig packageConfig : this.getParents()) {
                if (packageConfig.getExternalRefResolver() == null) continue;
                this.externalRefResolver = packageConfig.getExternalRefResolver();
                break;
            }
        }
        return this.externalRefResolver;
    }

    public String getFullDefaultInterceptorRef() {
        if (this.defaultInterceptorRef == null && !this.parents.isEmpty()) {
            for (PackageConfig parent : this.parents) {
                String parentDefault = parent.getFullDefaultInterceptorRef();
                if (parentDefault == null) continue;
                return parentDefault;
            }
        }
        return this.defaultInterceptorRef;
    }

    public String getFullDefaultResultType() {
        if (this.defaultResultType == null && !this.parents.isEmpty()) {
            for (PackageConfig parent : this.parents) {
                String parentDefault = parent.getFullDefaultResultType();
                if (parentDefault == null) continue;
                return parentDefault;
            }
        }
        return this.defaultResultType;
    }

    public Map getGlobalResultConfigs() {
        return this.globalResultConfigs;
    }

    public Map getInterceptorConfigs() {
        return this.interceptorConfigs;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace == null ? "" : namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public List getParents() {
        return new ArrayList(this.parents);
    }

    public Map getResultTypeConfigs() {
        return this.resultTypeConfigs;
    }

    public void addActionConfig(String name, ActionConfig action) {
        this.actionConfigs.put(name, action);
    }

    public void addAllParents(List parents) {
        for (PackageConfig config : parents) {
            this.addParent(config);
        }
    }

    public void addGlobalResultConfig(ResultConfig resultConfig) {
        this.globalResultConfigs.put(resultConfig.getName(), resultConfig);
    }

    public void addGlobalResultConfigs(Map resultConfigs) {
        this.globalResultConfigs.putAll(resultConfigs);
    }

    public void addInterceptorConfig(InterceptorConfig config) {
        this.interceptorConfigs.put(config.getName(), config);
    }

    public void addInterceptorStackConfig(InterceptorStackConfig config) {
        this.interceptorConfigs.put(config.getName(), config);
    }

    public void addParent(PackageConfig parent) {
        if (this.equals(parent)) {
            LOG.error((Object)("A package cannot extend itself: " + this.name));
        }
        this.parents.add(parent);
    }

    public void addResultTypeConfig(ResultTypeConfig config) {
        this.resultTypeConfigs.put(config.getName(), config);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackageConfig)) {
            return false;
        }
        PackageConfig packageConfig = (PackageConfig)o;
        if (this.isAbstract != packageConfig.isAbstract) {
            return false;
        }
        if (this.actionConfigs != null ? !this.actionConfigs.equals(packageConfig.actionConfigs) : packageConfig.actionConfigs != null) {
            return false;
        }
        if (this.defaultResultType != null ? !this.defaultResultType.equals(packageConfig.defaultResultType) : packageConfig.defaultResultType != null) {
            return false;
        }
        if (this.globalResultConfigs != null ? !this.globalResultConfigs.equals(packageConfig.globalResultConfigs) : packageConfig.globalResultConfigs != null) {
            return false;
        }
        if (this.interceptorConfigs != null ? !this.interceptorConfigs.equals(packageConfig.interceptorConfigs) : packageConfig.interceptorConfigs != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(packageConfig.name) : packageConfig.name != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(packageConfig.namespace) : packageConfig.namespace != null) {
            return false;
        }
        if (this.parents != null ? !this.parents.equals(packageConfig.parents) : packageConfig.parents != null) {
            return false;
        }
        return !(this.resultTypeConfigs != null ? !this.resultTypeConfigs.equals(packageConfig.resultTypeConfigs) : packageConfig.resultTypeConfigs != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 29 * result + (this.parents != null ? this.parents.hashCode() : 0);
        result = 29 * result + (this.actionConfigs != null ? this.actionConfigs.hashCode() : 0);
        result = 29 * result + (this.globalResultConfigs != null ? this.globalResultConfigs.hashCode() : 0);
        result = 29 * result + (this.interceptorConfigs != null ? this.interceptorConfigs.hashCode() : 0);
        result = 29 * result + (this.resultTypeConfigs != null ? this.resultTypeConfigs.hashCode() : 0);
        result = 29 * result + (this.defaultResultType != null ? this.defaultResultType.hashCode() : 0);
        result = 29 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
        result = 29 * result + (this.isAbstract ? 1 : 0);
        return result;
    }

    public void removeParent(PackageConfig parent) {
        this.parents.remove(parent);
    }

    public String toString() {
        return "{PackageConfig Name:" + this.name + " namespace:" + this.namespace + " abstract:" + this.isAbstract + " parents:" + this.parents + "}";
    }
}

