/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork;

import com.opensymphony.xwork.ValidationAware;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ValidationAwareSupport
implements ValidationAware {
    private Collection actionErrors;
    private Collection actionMessages;
    private Map fieldErrors;

    @Override
    public synchronized void setActionErrors(Collection errorMessages) {
        this.actionErrors = errorMessages;
    }

    @Override
    public synchronized Collection getActionErrors() {
        return new ArrayList(this.internalGetActionErrors());
    }

    @Override
    public synchronized void setActionMessages(Collection messages) {
        this.actionMessages = messages;
    }

    @Override
    public synchronized Collection getActionMessages() {
        return new ArrayList(this.internalGetActionMessages());
    }

    @Override
    public synchronized void setFieldErrors(Map errorMap) {
        this.fieldErrors = errorMap;
    }

    @Override
    public synchronized Map getFieldErrors() {
        return new HashMap(this.internalGetFieldErrors());
    }

    @Override
    public synchronized void addActionError(String anErrorMessage) {
        this.internalGetActionErrors().add(anErrorMessage);
    }

    @Override
    public void addActionMessage(String aMessage) {
        this.internalGetActionMessages().add(aMessage);
    }

    @Override
    public synchronized void addFieldError(String fieldName, String errorMessage) {
        Map errors = this.internalGetFieldErrors();
        ArrayList<String> thisFieldErrors = (ArrayList<String>)errors.get(fieldName);
        if (thisFieldErrors == null) {
            thisFieldErrors = new ArrayList<String>();
            errors.put(fieldName, thisFieldErrors);
        }
        thisFieldErrors.add(errorMessage);
    }

    @Override
    public synchronized boolean hasActionErrors() {
        return this.actionErrors != null && !this.actionErrors.isEmpty();
    }

    @Override
    public boolean hasActionMessages() {
        return this.actionMessages != null && !this.actionMessages.isEmpty();
    }

    @Override
    public synchronized boolean hasErrors() {
        return this.hasActionErrors() || this.hasFieldErrors();
    }

    @Override
    public synchronized boolean hasFieldErrors() {
        return this.fieldErrors != null && !this.fieldErrors.isEmpty();
    }

    private Collection internalGetActionErrors() {
        if (this.actionErrors == null) {
            this.actionErrors = new ArrayList();
        }
        return this.actionErrors;
    }

    private Collection internalGetActionMessages() {
        if (this.actionMessages == null) {
            this.actionMessages = new ArrayList();
        }
        return this.actionMessages;
    }

    private Map internalGetFieldErrors() {
        if (this.fieldErrors == null) {
            this.fieldErrors = new HashMap();
        }
        return this.fieldErrors;
    }
}

