/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork;

import com.opensymphony.xwork.Action;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.ActionProxy;
import com.opensymphony.xwork.ActionProxyFactory;
import com.opensymphony.xwork.config.ConfigurationException;
import com.opensymphony.xwork.config.ConfigurationManager;
import com.opensymphony.xwork.config.entities.ActionConfig;
import com.opensymphony.xwork.util.LocalizedTextUtil;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultActionProxy
implements ActionProxy {
    private static final Log LOG = LogFactory.getLog(DefaultActionProxy.class);
    protected ActionConfig config;
    protected ActionInvocation invocation;
    protected Map extraContext;
    protected String actionName;
    protected String namespace;
    protected boolean executeResult;

    protected DefaultActionProxy(String namespace, String actionName, Map extraContext, boolean executeResult) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating an DefaultActionProxy for namespace " + namespace + " and action name " + actionName));
        }
        this.actionName = actionName;
        this.namespace = namespace;
        this.executeResult = executeResult;
        this.extraContext = extraContext;
        this.config = ConfigurationManager.getConfiguration().getRuntimeConfiguration().getActionConfig(namespace, actionName);
        if (this.config == null) {
            String message = namespace != null && namespace.trim().length() > 0 ? LocalizedTextUtil.findDefaultText("xwork.exception.missing-package-action", Locale.getDefault(), new String[]{namespace, actionName}) : LocalizedTextUtil.findDefaultText("xwork.exception.missing-action", Locale.getDefault(), new String[]{actionName});
            throw new ConfigurationException(message);
        }
        this.prepare();
    }

    @Override
    public Action getAction() {
        return this.invocation.getAction();
    }

    @Override
    public String getActionName() {
        return this.actionName;
    }

    @Override
    public ActionConfig getConfig() {
        return this.config;
    }

    @Override
    public void setExecuteResult(boolean executeResult) {
        this.executeResult = executeResult;
    }

    @Override
    public boolean getExecuteResult() {
        return this.executeResult;
    }

    @Override
    public ActionInvocation getInvocation() {
        return this.invocation;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String execute() throws Exception {
        ActionContext nestedContext = ActionContext.getContext();
        ActionContext.setContext(this.invocation.getInvocationContext());
        String retCode = null;
        try {
            retCode = this.invocation.invoke();
        }
        finally {
            ActionContext.setContext(nestedContext);
        }
        return retCode;
    }

    protected void prepare() throws Exception {
        this.invocation = ActionProxyFactory.getFactory().createActionInvocation(this, this.extraContext);
    }
}

