/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork;

import com.opensymphony.xwork.Action;
import com.opensymphony.xwork.ActionChainResult;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.ActionProxy;
import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.Result;
import com.opensymphony.xwork.XworkException;
import com.opensymphony.xwork.config.entities.ActionConfig;
import com.opensymphony.xwork.config.entities.ResultConfig;
import com.opensymphony.xwork.interceptor.Interceptor;
import com.opensymphony.xwork.interceptor.PreResultListener;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultActionInvocation
implements ActionInvocation {
    private static final Log LOG = LogFactory.getLog(DefaultActionInvocation.class);
    protected Action action;
    protected ActionProxy proxy;
    protected List preResultListeners;
    protected Map extraContext;
    ActionContext invocationContext;
    Iterator interceptors;
    OgnlValueStack stack;
    Result result;
    String resultCode;
    boolean executed = false;
    boolean pushAction = true;

    protected DefaultActionInvocation(ActionProxy proxy) throws Exception {
        this(proxy, null);
    }

    protected DefaultActionInvocation(ActionProxy proxy, Map extraContext) throws Exception {
        this(proxy, extraContext, true);
    }

    protected DefaultActionInvocation(ActionProxy proxy, Map extraContext, boolean pushAction) throws Exception {
        this.proxy = proxy;
        this.extraContext = extraContext;
        this.pushAction = pushAction;
        this.init();
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    @Override
    public boolean isExecuted() {
        return this.executed;
    }

    @Override
    public ActionContext getInvocationContext() {
        return this.invocationContext;
    }

    @Override
    public ActionProxy getProxy() {
        return this.proxy;
    }

    @Override
    public Result getResult() throws Exception {
        Result proxyResult;
        ActionProxy aProxy;
        Result returnResult = this.result;
        while (returnResult instanceof ActionChainResult && (aProxy = ((ActionChainResult)returnResult).getProxy()) != null && (proxyResult = aProxy.getInvocation().getResult()) != null && aProxy.getExecuteResult()) {
            returnResult = proxyResult;
        }
        return returnResult;
    }

    @Override
    public String getResultCode() {
        return this.resultCode;
    }

    @Override
    public OgnlValueStack getStack() {
        return this.stack;
    }

    @Override
    public void addPreResultListener(PreResultListener listener) {
        if (this.preResultListeners == null) {
            this.preResultListeners = new ArrayList(1);
        }
        this.preResultListeners.add(listener);
    }

    public Result createResult() throws Exception {
        Map results = this.proxy.getConfig().getResults();
        ResultConfig resultConfig = (ResultConfig)results.get(this.resultCode);
        Result newResult = null;
        if (resultConfig != null) {
            try {
                newResult = ObjectFactory.getObjectFactory().buildResult(resultConfig);
            }
            catch (Exception e) {
                LOG.error((Object)("There was an exception while instantiating the result of type " + resultConfig.getClassName()), (Throwable)e);
                throw e;
            }
        }
        return newResult;
    }

    @Override
    public String invoke() throws Exception {
        if (this.executed) {
            throw new IllegalStateException("Action has already executed");
        }
        if (this.interceptors.hasNext()) {
            Interceptor interceptor = (Interceptor)this.interceptors.next();
            this.resultCode = interceptor.intercept(this);
        } else {
            this.resultCode = this.proxy.getConfig().getMethodName() == null ? this.getAction().execute() : this.invokeAction(this.getAction(), this.proxy.getConfig());
        }
        if (!this.executed) {
            if (this.preResultListeners != null) {
                for (PreResultListener listener : this.preResultListeners) {
                    listener.beforeResult(this, this.resultCode);
                }
            }
            if (this.proxy.getExecuteResult()) {
                this.executeResult();
            }
            this.executed = true;
        }
        return this.resultCode;
    }

    protected void createAction() {
        try {
            this.action = ObjectFactory.getObjectFactory().buildAction(this.proxy.getConfig());
        }
        catch (InstantiationException e) {
            throw new XworkException("Unable to intantiate Action!", e);
        }
        catch (IllegalAccessException e) {
            throw new XworkException("Illegal access to constructor, is it public?", e);
        }
        catch (ClassCastException e) {
            throw new XworkException("Action class " + this.proxy.getConfig().getClassName() + " does not implement " + Action.class.getName(), e);
        }
        catch (Exception e) {
            String gripe = "";
            gripe = this.proxy == null ? "Whoa!  No ActionProxy instance found in current ActionInvocation.  This is bad ... very bad" : (this.proxy.getConfig() == null ? "Sheesh.  Where'd that ActionProxy get to?  I can't find it in the current ActionInvocation!?" : (this.proxy.getConfig().getClassName() == null ? "No Action defined for '" + this.proxy.getActionName() + "' in namespace '" + this.proxy.getNamespace() + "'" : "Unable to instantiate Action, " + this.proxy.getConfig().getClassName() + ",  defined for '" + this.proxy.getActionName() + "' in namespace '" + this.proxy.getNamespace() + "'"));
            gripe = gripe + (" -- " + e.getMessage() != null ? e.getMessage() : " [no message in exception]");
            throw new XworkException(gripe, e);
        }
    }

    protected Map createContextMap() {
        Map contextMap;
        if (this.extraContext != null && this.extraContext.containsKey("com.opensymphony.xwork.util.OgnlValueStack.ValueStack")) {
            this.stack = (OgnlValueStack)this.extraContext.get("com.opensymphony.xwork.util.OgnlValueStack.ValueStack");
            if (this.stack == null) {
                throw new IllegalStateException("There was a null Stack set into the extra params.");
            }
            contextMap = this.stack.getContext();
        } else {
            this.stack = new OgnlValueStack();
            contextMap = this.stack.getContext();
        }
        if (this.extraContext != null) {
            contextMap.putAll(this.extraContext);
        }
        contextMap.put("com.opensymphony.xwork.ActionContext.actionInvocation", this);
        return contextMap;
    }

    private void executeResult() throws Exception {
        this.result = this.createResult();
        if (this.result != null) {
            this.result.execute(this);
        } else if (!"none".equals(this.resultCode)) {
            LOG.warn((Object)("No result defined for action " + this.getAction().getClass().getName() + " and result " + this.getResultCode()));
        }
    }

    private void init() throws Exception {
        Map contextMap = this.createContextMap();
        this.createAction();
        if (this.pushAction) {
            this.stack.push(this.action);
        }
        this.invocationContext = new ActionContext(contextMap);
        this.invocationContext.setName(this.proxy.getActionName());
        ArrayList interceptorList = new ArrayList(this.proxy.getConfig().getInterceptors());
        this.interceptors = interceptorList.iterator();
    }

    private String invokeAction(Action action, ActionConfig actionConfig) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Executing action method = " + actionConfig.getMethodName()));
        }
        try {
            Method method = actionConfig.getMethod();
            if (action instanceof Proxy) {
                try {
                    return (String)Proxy.getInvocationHandler(action).invoke(action, method, new Object[0]);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    throw new Exception("Error invoking on proxy: " + throwable.getMessage());
                }
            }
            return (String)method.invoke((Object)action, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Method '" + actionConfig.getMethodName() + "()' is not defined in action '" + this.getAction().getClass() + "'");
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw e;
        }
    }
}

