/*
 * Copyright (c) 2002-2003 by OpenSymphony
 * All rights reserved.
 */
package com.opensymphony.xwork.util;


import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Utility class for text parsing.
 *
 * @author Jason Carreira
 * Created Feb 10, 2003 8:55:11 PM
 */
public class TextParseUtil {
    //~ Methods ////////////////////////////////////////////////////////////////

    /**
     * Converts all instances of ${...} in <code>expression</code> to the value returned
     * by a call to {@link OgnlValueStack#findValue(java.lang.String)}. If an item cannot
     * be found on the stack (null is returned), then the entire variable ${...} is not
     * displayed, just as if the item was on the stack but returned an empty string.
     *
     * @param expression an expression that hasn't yet been translated
     * @return the parsed expression
     */
    public static String translateVariables(String expression, final OgnlValueStack stack) {
        StringBuilder sb = new StringBuilder();
        Pattern p = Pattern.compile("\\$\\{([^}]*)\\}");
        Matcher m = p.matcher(expression);
        int previous = 0;
        while (m.find()) {
            String g = m.group(1);
            int start = m.start();
            String value;
            try {
                Object o = stack.findValue(g);
                value = o == null ? "" : o.toString();
            } catch (Exception ignored) {
                value = "";
            }
            sb.append(expression.substring(previous, start)).append(value);
            previous = m.end();
        }
        if (previous < expression.length() ) {
            sb.append(expression.substring(previous));
        }
        return sb.toString();
    }
}
