/*
 * Copyright (c) 2002-2003 by OpenSymphony
 * All rights reserved.
 */
package com.opensymphony.xwork.config;

import com.opensymphony.xwork.config.entities.PackageConfig;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;


/**
 * ConfigurationUtil
 * @author Jason Carreira
 * Created May 23, 2003 11:22:49 PM
 */
public class ConfigurationUtil {
    //~ Static fields/initializers /////////////////////////////////////////////

    private static final Log LOG = LogFactory.getLog(ConfigurationUtil.class);

    //~ Constructors ///////////////////////////////////////////////////////////

    private ConfigurationUtil() {
    }

    //~ Methods ////////////////////////////////////////////////////////////////

    public static List buildParentsFromString(Configuration configuration, String parent) {
        if ((parent == null) || (parent.equals(""))) {
            return Collections.EMPTY_LIST;
        }

        StringTokenizer tokenizer = new StringTokenizer(parent, ", ");
        List parents = new ArrayList();

        while (tokenizer.hasMoreTokens()) {
            String parentName = tokenizer.nextToken().trim();

            if (!parentName.equals("")) {
                PackageConfig parentPackageContext = configuration.getPackageConfig(parentName);

                if (parentPackageContext == null) {
                    LOG.error("Unable to find parent package " + parentName);
                } else {
                    parents.add(parentPackageContext);
                }
            }
        }

        return parents;
    }
}
