/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher.mapper;

import com.opensymphony.webwork.RequestUtils;
import com.opensymphony.webwork.dispatcher.mapper.ActionMapper;
import com.opensymphony.webwork.dispatcher.mapper.ActionMapping;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RestfulActionMapper
implements ActionMapper {
    protected static final Log LOG = LogFactory.getLog((Class)RestfulActionMapper.class);

    public ActionMapping getMapping(HttpServletRequest request) {
        int nextSlash;
        String uri = RequestUtils.getServletPath(request);
        if (uri.indexOf(".") != -1) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("request (servlet path)=" + uri));
        }
        if ((nextSlash = uri.indexOf(47, 1)) == -1) {
            return null;
        }
        String actionName = uri.substring(1, nextSlash);
        HashMap<String, String> parameters = new HashMap<String, String>();
        try {
            StringTokenizer st = new StringTokenizer(uri.substring(nextSlash), "/");
            boolean isNameTok = true;
            String paramName = null;
            if (st.countTokens() % 2 != 0) {
                isNameTok = false;
                paramName = actionName + "Id";
            }
            while (st.hasMoreTokens()) {
                if (isNameTok) {
                    paramName = URLDecoder.decode(st.nextToken(), "UTF-8");
                    isNameTok = false;
                    continue;
                }
                String paramValue = URLDecoder.decode(st.nextToken(), "UTF-8");
                if (paramName != null && paramName.length() > 0) {
                    parameters.put(paramName, paramValue);
                }
                isNameTok = true;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)e);
        }
        LOG.debug((Object)("actionName=" + actionName));
        LOG.debug((Object)("params=" + parameters.size()));
        return new ActionMapping(actionName, "", "", parameters);
    }

    public String getUriFromActionMapping(ActionMapping mapping) {
        if (mapping.getNamespace() == null || mapping.getNamespace().trim().length() <= 0) {
            String base = "/" + mapping.getName();
            Map parameters = mapping.getParams();
            if (parameters.containsKey(mapping.getName() + "Id")) {
                base = base + "/" + parameters.get(mapping.getName() + "Id");
            }
            Iterator iterator = parameters.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String name = (String)entry.getKey();
                if (name.equals(mapping.getName() + "Id")) continue;
                base = base + "/" + entry.getKey() + "/" + entry.getValue();
            }
            return base + "/";
        }
        return null;
    }
}

