/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.spring;

import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.util.ObjectFactoryInitializable;
import com.opensymphony.xwork.spring.SpringObjectFactory;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class WebWorkSpringObjectFactory
extends SpringObjectFactory
implements ObjectFactoryInitializable {
    private static final Log log = LogFactory.getLog(WebWorkSpringObjectFactory.class);

    public void init(ServletContext servletContext) {
        log.info((Object)"Initializing WebWork-Spring integration...");
        WebApplicationContext appContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        if (appContext == null) {
            String message = "********** FATAL ERROR STARTING UP SPRING-WEBWORK INTEGRATION **********\nLooks like the Spring listener was not configured for your web app! \nNothing will work until WebApplicationContextUtils returns a valid ApplicationContext.\nYou might need to add the following to web.xml: \n    <listener>\n        <listener-class>org.springframework.web.context.ContextLoaderListener</listener-class>\n    </listener>";
            log.fatal((Object)message);
            return;
        }
        this.setApplicationContext((ApplicationContext)appContext);
        String autoWire = Configuration.getString("webwork.objectFactory.spring.autoWire");
        int type = 1;
        if ("name".equals(autoWire)) {
            type = 1;
        } else if ("type".equals(autoWire)) {
            type = 2;
        } else if ("auto".equals(autoWire)) {
            type = 4;
        } else if ("constructor".equals(autoWire)) {
            type = 3;
        }
        this.setAutowireStrategy(type);
        boolean useClassCache = "true".equals(Configuration.getString("webwork.objectFactory.spring.useClassCache"));
        this.setUseClassCache(useClassCache);
        log.info((Object)"... initialized WebWork-Spring integration successfully");
    }
}

