/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.plexus;

import com.opensymphony.webwork.plexus.PlexusFilter;
import com.opensymphony.webwork.plexus.PlexusLifecycleListener;
import com.opensymphony.webwork.plexus.PlexusThreadLocal;
import com.opensymphony.webwork.util.ObjectFactoryInitializable;
import com.opensymphony.xwork.ObjectFactory;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.PlexusContainer;

public class PlexusObjectFactory
extends ObjectFactory
implements ObjectFactoryInitializable {
    private static final Log log = LogFactory.getLog(PlexusObjectFactory.class);
    private PlexusContainer base;

    public void init(ServletContext servletContext) {
        if (!PlexusLifecycleListener.loaded || !PlexusFilter.loaded) {
            String message = "********** FATAL ERROR STARTING UP PLEXUS-WEBWORK INTEGRATION **********\nLooks like the Plexus listener was not configured for your web app! \nYou need to add the following to web.xml: \n\n    <!-- this should be before the webwork filter -->\n    <filter>\n        <filter-name>plexus</filter-name>\n        <filter-class>com.opensymphony.webwork.plexus.PlexusFilter</filter-class>\n    </filter>\n\n...\n\n    <!-- this should be before the webwork filter -->\n    <filter-mapping>\n        <filter-name>plexus</filter-name>\n        <url-pattern>/*</url-pattern>\n    </filter-mapping>\n\n...\n\n    <listener>\n        <listener-class>com.opensymphony.webwork.plexus.PlexusLifecycleListener</listener-class>\n    </listener>";
            log.fatal((Object)message);
            return;
        }
        this.base = (PlexusContainer)servletContext.getAttribute("webwork.plexus.container");
    }

    public Object buildBean(String className, Map extraContext) throws Exception {
        PlexusContainer pc = PlexusThreadLocal.getPlexusContainer();
        if (pc == null) {
            pc = this.base;
        }
        try {
            return pc.lookup(className);
        }
        catch (Exception e) {
            Object o = super.buildBean(className, extraContext);
            pc.autowire(o);
            return o;
        }
    }
}

