/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.interceptor;

import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.AroundInterceptor;
import com.opensymphony.xwork.interceptor.PreResultListener;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FlashInterceptor
extends AroundInterceptor {
    public static final String DEFAULT_KEY = "__flashAction";
    public static final String STORE = "Store";
    public static final String RETRIEVE = "Retrieve";
    private static final Log LOG = LogFactory.getLog(FlashInterceptor.class);
    private static final long serialVersionUID = -9200319895107209641L;
    private String key = "__flashAction";
    private String operation = "Retrieve";

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getOperation() {
        return this.operation;
    }

    protected void after(ActionInvocation invocation, String result) throws Exception {
    }

    protected void before(ActionInvocation invocation) throws Exception {
        Map sessionMap = ActionContext.getContext().getSession();
        if (STORE.equalsIgnoreCase(this.operation)) {
            invocation.addPreResultListener(new PreResultListener(){

                public void beforeResult(ActionInvocation invocation, String resultCode) {
                    Map sessionMap = ActionContext.getContext().getSession();
                    Object action = invocation.getAction();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("inserting action [" + action + "] into session with key [" + FlashInterceptor.this.key + "]"));
                    }
                    sessionMap.put(FlashInterceptor.this.key, action);
                }
            });
        }
        if (RETRIEVE.equalsIgnoreCase(this.operation)) {
            if (sessionMap.get(this.key) != null) {
                Object action = sessionMap.get(this.key);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("flash action with key [" + this.key + "] found in session, pushed action [" + action + "] into stack"));
                }
                OgnlValueStack stack = (OgnlValueStack)ActionContext.getContext().get((Object)"com.opensymphony.xwork.util.OgnlValueStack.ValueStack");
                stack.push(action);
                sessionMap.remove(this.key);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("flash action with key [" + this.key + "] with actual type [" + action + "] removed from session after being pushed into the stack "));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("flash action key [" + this.key + "] not found in session, no action is pushed into stack"));
            }
        }
    }
}

