/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.pico;

import com.opensymphony.webwork.pico.PicoObjectFactory;
import com.opensymphony.xwork.ObjectFactory;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.picocontainer.defaults.ObjectReference;
import org.picocontainer.gems.adapters.ThreadLocalReference;

public class PicoObjectFactoryFilter
implements Filter {
    private static final String ALREADY_FILTERED_KEY = "nanocontainer_objectfactory_filtered";
    private ObjectReference objectReference;

    public void init(FilterConfig config) throws ServletException {
        this.objectReference = new ThreadLocalReference();
        ObjectFactory.setObjectFactory((ObjectFactory)new PicoObjectFactory(this.objectReference));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        if (httpServletRequest.getAttribute(ALREADY_FILTERED_KEY) == null) {
            httpServletRequest.setAttribute(ALREADY_FILTERED_KEY, (Object)Boolean.TRUE);
            this.objectReference.set((Object)httpServletRequest);
            try {
                chain.doFilter(request, response);
            }
            finally {
                this.objectReference.set(null);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

