package com.opensymphony.webwork.interceptor;

import com.opensymphony.xwork.interceptor.Interceptor;

/**
 * Added here so Spring can proxy interceptors
 */
public interface ExecuteAndWaitInterceptorInterface extends Interceptor
{
    /**
     * Sets the thread priority of the background process.
     *
     * @param threadPriority the priority from <code>Thread.XXX</code>
     */
    void setThreadPriority(int threadPriority);

    /**
     * Sets the initial delay in millis (msec).
     *
     * @param delay in millis. (0 for not used)
     */
    void setDelay(int delay);

    /**
     * Sets the sleep interval in millis (msec) when performing the initial delay.
     *
     * @param delaySleepInterval in millis (0 for not used)
     */
    void setDelaySleepInterval(int delaySleepInterval);
}
