/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components;

import com.opensymphony.webwork.components.Form;
import com.opensymphony.webwork.components.Select;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpDownSelect
extends Select {
    private static final Log _log = LogFactory.getLog(UpDownSelect.class);
    public static final String TEMPLATE = "updownselect";
    protected String allowMoveUp;
    protected String allowMoveDown;
    protected String allowSelectAll;
    protected String moveUpLabel;
    protected String moveDownLabel;
    protected String selectAllLabel;

    public String getDefaultTemplate() {
        return TEMPLATE;
    }

    public UpDownSelect(OgnlValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    public void evaluateParams() {
        Form ancestorForm;
        super.evaluateParams();
        if (this.size == null || this.size.trim().length() <= 0) {
            this.addParameter("size", "5");
        }
        if (this.multiple == null || this.multiple.trim().length() <= 0) {
            this.addParameter("multiple", Boolean.TRUE);
        }
        if (this.allowMoveUp != null) {
            this.addParameter("allowMoveUp", this.findValue(this.allowMoveUp, Boolean.class));
        }
        if (this.allowMoveDown != null) {
            this.addParameter("allowMoveDown", this.findValue(this.allowMoveDown, Boolean.class));
        }
        if (this.allowSelectAll != null) {
            this.addParameter("allowSelectAll", this.findValue(this.allowSelectAll, Boolean.class));
        }
        if (this.moveUpLabel != null) {
            this.addParameter("moveUpLabel", this.findString(this.moveUpLabel));
        }
        if (this.moveDownLabel != null) {
            this.addParameter("moveDownLabel", this.findString(this.moveDownLabel));
        }
        if (this.selectAllLabel != null) {
            this.addParameter("selectAllLabel", this.findString(this.selectAllLabel));
        }
        if ((ancestorForm = (Form)this.findAncestor(Form.class)) != null) {
            this.enableAncestorFormCustomOnsubmit();
            LinkedHashMap m = (LinkedHashMap)ancestorForm.getParameters().get("updownselectIds");
            if (m == null) {
                m = new LinkedHashMap();
            }
            m.put(this.getParameters().get("id"), this.getParameters().get("headerKey"));
            ancestorForm.getParameters().put("updownselectIds", m);
        } else {
            _log.warn((Object)("no ancestor form found for updownselect " + this + ", therefore autoselect of all elements unpon form submission will not work "));
        }
    }

    public String getAllowMoveUp() {
        return this.allowMoveUp;
    }

    public void setAllowMoveUp(String allowMoveUp) {
        this.allowMoveUp = allowMoveUp;
    }

    public String getAllowMoveDown() {
        return this.allowMoveDown;
    }

    public void setAllowMoveDown(String allowMoveDown) {
        this.allowMoveDown = allowMoveDown;
    }

    public String getAllowSelectAll() {
        return this.allowSelectAll;
    }

    public void setAllowSelectAll(String allowSelectAll) {
        this.allowSelectAll = allowSelectAll;
    }

    public String getMoveUpLabel() {
        return this.moveUpLabel;
    }

    public void setMoveUpLabel(String moveUpLabel) {
        this.moveUpLabel = moveUpLabel;
    }

    public String getMoveDownLabel() {
        return this.moveDownLabel;
    }

    public void setMoveDownLabel(String moveDownLabel) {
        this.moveDownLabel = moveDownLabel;
    }

    public String getSelectAllLabel() {
        return this.selectAllLabel;
    }

    public void setSelectAllLabel(String selectAllLabel) {
        this.selectAllLabel = selectAllLabel;
    }
}

