/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.util;

import com.opensymphony.webwork.components.Component;
import com.opensymphony.webwork.components.Form;
import com.opensymphony.xwork.util.OgnlUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityUtil {
    public static final String OGNL_UNSAFE = "OgnlUnsafe";

    private SecurityUtil() {
    }

    public static Map<String, Object> getUnescapedParameters(Log log, Component bean, Map<String, Object> parameters) {
        if (parameters == null) {
            return null;
        }
        HashMap<String, Object> unescapedParameters = parameters instanceof HashMap ? new HashMap() : new TreeMap();
        for (Map.Entry<String, Object> keyValue : parameters.entrySet()) {
            String key = keyValue.getKey();
            if (key.endsWith(OGNL_UNSAFE)) continue;
            Object escapedOrOveriddenValue = keyValue.getValue();
            Object unescapedValue = SecurityUtil.getUnescapedValue(parameters, key);
            if (unescapedValue instanceof String) {
                unescapedParameters.put(key, unescapedValue);
                String reescapedValue = SecurityUtil.wrapAsOgnlExpression(OgnlUtil.escapeLiteral((String)((String)unescapedValue)).toString());
                if (reescapedValue.equals(escapedOrOveriddenValue)) {
                    unescapedParameters.put(key, unescapedValue);
                    continue;
                }
                boolean knownOverridingTag = bean instanceof Form;
                if (!knownOverridingTag && !key.equals("name") && log != null) {
                    String beanName = bean != null ? bean.getClass().getCanonicalName() : "unknown";
                    log.warn((Object)(key + " was overridden to " + escapedOrOveriddenValue + " for " + beanName));
                }
                unescapedParameters.put(key, escapedOrOveriddenValue);
                continue;
            }
            unescapedParameters.put(key, escapedOrOveriddenValue);
        }
        return unescapedParameters;
    }

    public static String wrapAsOgnlExpression(String expr) {
        return "%{" + expr + "}";
    }

    public static boolean hasUnescapedValue(Map parameters, String name) {
        return parameters.containsKey(SecurityUtil.getNameOfUnEscapedParameter(name));
    }

    private static Object getUnescapedValue(Map<String, Object> parameters, String name) {
        return parameters.get(SecurityUtil.getNameOfUnEscapedParameter(name));
    }

    private static String getNameOfUnEscapedParameter(String name) {
        return name + OGNL_UNSAFE;
    }
}

