/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.util.classloader.stores;

import com.opensymphony.webwork.util.classloader.stores.ResourceStore;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MemoryResourceStore
implements ResourceStore {
    private static final Log log = LogFactory.getLog(MemoryResourceStore.class);
    private final Map store = new HashMap();

    public byte[] read(String resourceName) {
        return (byte[])this.store.get(resourceName);
    }

    public void write(String resourceName, byte[] clazzData) {
        log.debug((Object)("storing resource " + resourceName + "(" + clazzData.length + ")"));
        this.store.put(resourceName, clazzData);
    }

    public void remove(String resourceName) {
        log.debug((Object)("removing resource " + resourceName));
        this.store.remove(resourceName);
    }

    public String toString() {
        return this.store.keySet().toString();
    }
}

