/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.util.classloader.compilers.eclipse;

import com.opensymphony.webwork.util.classloader.compilers.JavaCompiler;
import com.opensymphony.webwork.util.classloader.compilers.eclipse.EclipseCompilationProblem;
import com.opensymphony.webwork.util.classloader.compilers.eclipse.EclipseJavaCompilerSettings;
import com.opensymphony.webwork.util.classloader.problems.CompilationProblemHandler;
import com.opensymphony.webwork.util.classloader.readers.ResourceReader;
import com.opensymphony.webwork.util.classloader.stores.ResourceStore;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;

public final class EclipseJavaCompiler
implements JavaCompiler {
    private static final Log log = LogFactory.getLog(EclipseJavaCompiler.class);
    private final EclipseJavaCompilerSettings settings;

    public EclipseJavaCompiler() {
        this(new EclipseJavaCompilerSettings());
    }

    public EclipseJavaCompiler(EclipseJavaCompilerSettings pSettings) {
        this.settings = pSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(String[] pClazzNames, final ResourceReader pReader, final ResourceStore pStore, final CompilationProblemHandler pProblemHandler) {
        Map settingsMap = this.settings.getMap();
        HashSet<String> clazzIndex = new HashSet<String>();
        ICompilationUnit[] compilationUnits = new ICompilationUnit[pClazzNames.length];
        for (int i = 0; i < compilationUnits.length; ++i) {
            String clazzName = pClazzNames[i];
            compilationUnits[i] = new CompilationUnit(pReader, clazzName);
            clazzIndex.add(clazzName);
            log.debug((Object)("compiling " + clazzName));
        }
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
        INameEnvironment nameEnvironment = new INameEnvironment(){

            public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
                StringBuffer result = new StringBuffer();
                for (int i = 0; i < compoundTypeName.length; ++i) {
                    if (i != 0) {
                        result.append('.');
                    }
                    result.append(compoundTypeName[i]);
                }
                return this.findType(result.toString());
            }

            public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
                StringBuffer result = new StringBuffer();
                for (int i = 0; i < packageName.length; ++i) {
                    result.append(packageName[i]);
                    result.append('.');
                }
                result.append(typeName);
                return this.findType(result.toString());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private NameEnvironmentAnswer findType(String clazzName) {
                byte[] clazzBytes = pStore.read(clazzName);
                if (clazzBytes != null) {
                    char[] fileName = clazzName.toCharArray();
                    try {
                        ClassFileReader classFileReader = new ClassFileReader(clazzBytes, fileName, true);
                        return new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
                    }
                    catch (ClassFormatException e) {
                        log.error((Object)"wrong class format", (Throwable)e);
                    }
                } else {
                    if (pReader.isAvailable(clazzName.replace('.', '/') + ".java")) {
                        log.debug((Object)("compile " + clazzName));
                        CompilationUnit compilationUnit = new CompilationUnit(pReader, clazzName);
                        return new NameEnvironmentAnswer((ICompilationUnit)compilationUnit, null);
                    }
                    String resourceName = clazzName.replace('.', '/') + ".class";
                    InputStream is = this.getClass().getClassLoader().getResourceAsStream(resourceName);
                    if (is != null) {
                        byte[] buffer = new byte[8192];
                        ByteArrayOutputStream baos = new ByteArrayOutputStream(buffer.length);
                        try {
                            int count;
                            while ((count = is.read(buffer, 0, buffer.length)) > 0) {
                                baos.write(buffer, 0, count);
                            }
                            baos.flush();
                            clazzBytes = baos.toByteArray();
                            char[] fileName = clazzName.toCharArray();
                            ClassFileReader classFileReader = new ClassFileReader(clazzBytes, fileName, true);
                            NameEnvironmentAnswer nameEnvironmentAnswer = new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
                            return nameEnvironmentAnswer;
                        }
                        catch (IOException e) {
                            log.error((Object)"could not read class", (Throwable)e);
                        }
                        catch (ClassFormatException e) {
                            log.error((Object)"wrong class format", (Throwable)e);
                        }
                        finally {
                            try {
                                baos.close();
                            }
                            catch (IOException oe) {
                                log.error((Object)"could not close output stream", (Throwable)oe);
                            }
                            try {
                                is.close();
                            }
                            catch (IOException ie) {
                                log.error((Object)"could not close input stream", (Throwable)ie);
                            }
                        }
                    }
                }
                return null;
            }

            private boolean isPackage(String clazzName) {
                String resourceName = clazzName.replace('.', '/') + ".class";
                URL resource = this.getClass().getClassLoader().getResource(resourceName);
                return resource == null;
            }

            public boolean isPackage(char[][] parentPackageName, char[] packageName) {
                StringBuffer result = new StringBuffer();
                if (parentPackageName != null) {
                    for (int i = 0; i < parentPackageName.length; ++i) {
                        if (i != 0) {
                            result.append('.');
                        }
                        result.append(parentPackageName[i]);
                    }
                }
                if (Character.isUpperCase(packageName[0])) {
                    return false;
                }
                if (parentPackageName != null && parentPackageName.length > 0) {
                    result.append('.');
                }
                result.append(packageName);
                return this.isPackage(result.toString());
            }

            public void cleanup() {
            }
        };
        ICompilerRequestor compilerRequestor = new ICompilerRequestor(){

            public void acceptResult(CompilationResult result) {
                int i;
                if (result.hasProblems() && pProblemHandler != null) {
                    IProblem[] problems = result.getProblems();
                    for (i = 0; i < problems.length; ++i) {
                        IProblem problem = problems[i];
                        pProblemHandler.handle(new EclipseCompilationProblem(problem));
                    }
                }
                if (!result.hasErrors()) {
                    ClassFile[] clazzFiles = result.getClassFiles();
                    for (i = 0; i < clazzFiles.length; ++i) {
                        ClassFile clazzFile = clazzFiles[i];
                        char[][] compoundName = clazzFile.getCompoundName();
                        StringBuffer clazzName = new StringBuffer();
                        for (int j = 0; j < compoundName.length; ++j) {
                            if (j != 0) {
                                clazzName.append('.');
                            }
                            clazzName.append(compoundName[j]);
                        }
                        pStore.write(clazzName.toString(), clazzFile.getBytes());
                    }
                }
            }
        };
        pProblemHandler.onStart();
        try {
            Compiler compiler = new Compiler(nameEnvironment, policy, settingsMap, compilerRequestor, (IProblemFactory)problemFactory);
            compiler.compile(compilationUnits);
        }
        finally {
            pProblemHandler.onStop();
        }
    }

    final class CompilationUnit
    implements ICompilationUnit {
        private final String clazzName;
        private final String fileName;
        private final char[] typeName;
        private final char[][] packageName;
        private final ResourceReader reader;

        CompilationUnit(ResourceReader pReader, String pClazzName) {
            this.reader = pReader;
            this.clazzName = pClazzName;
            this.fileName = StringUtils.replaceChars((String)this.clazzName, (char)'.', (char)'/') + ".java";
            int dot = this.clazzName.lastIndexOf(46);
            this.typeName = dot > 0 ? this.clazzName.substring(dot + 1).toCharArray() : this.clazzName.toCharArray();
            StringTokenizer izer = new StringTokenizer(this.clazzName, ".");
            this.packageName = new char[izer.countTokens() - 1][];
            for (int i = 0; i < this.packageName.length; ++i) {
                this.packageName[i] = izer.nextToken().toCharArray();
            }
        }

        public char[] getFileName() {
            return this.fileName.toCharArray();
        }

        public char[] getContents() {
            return this.reader.getContent(this.fileName);
        }

        public char[] getMainTypeName() {
            return this.typeName;
        }

        public char[][] getPackageName() {
            return this.packageName;
        }
    }
}

