/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher;

import com.opensymphony.webwork.dispatcher.WebWorkResultSupport;
import com.opensymphony.xwork.ActionInvocation;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlainTextResult
extends WebWorkResultSupport {
    private static final Log _log = LogFactory.getLog(PlainTextResult.class);
    private static final long serialVersionUID = 3633371605905583950L;
    public static final int BUFFER_SIZE = 1024;
    private String charSet;

    public String getCharSet() {
        return this.charSet;
    }

    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        Charset charset = null;
        if (this.charSet != null) {
            if (Charset.isSupported(this.charSet)) {
                charset = Charset.forName(this.charSet);
            } else {
                _log.warn((Object)("charset [" + this.charSet + "] is not recognized "));
                charset = null;
            }
        }
        HttpServletResponse response = (HttpServletResponse)invocation.getInvocationContext().get((Object)"com.opensymphony.xwork.dispatcher.HttpServletResponse");
        ServletContext servletContext = (ServletContext)invocation.getInvocationContext().get((Object)"com.opensymphony.xwork.dispatcher.ServletContext");
        if (charset != null) {
            response.setContentType("text/plain; charset=" + this.charSet);
        } else {
            response.setContentType("text/plain");
        }
        response.setHeader("Content-Disposition", "inline");
        PrintWriter writer = response.getWriter();
        InputStreamReader reader = null;
        try {
            reader = charset != null ? new InputStreamReader(servletContext.getResourceAsStream(this.location), charset) : new InputStreamReader(servletContext.getResourceAsStream(this.location));
            if (reader == null) {
                _log.warn((Object)("resource at location [" + this.location + "] cannot be obtained (return null) from ServletContext !!! "));
            } else {
                char[] buffer = new char[1024];
                int charRead = 0;
                while ((charRead = reader.read(buffer)) != -1) {
                    writer.write(buffer, 0, charRead);
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
    }
}

