/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.interceptor;

import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.WebWorkException;
import com.opensymphony.webwork.dispatcher.SessionMap;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.ActionProxy;
import com.opensymphony.xwork.interceptor.Interceptor;
import com.opensymphony.xwork.interceptor.PreResultListener;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScopeInterceptor
implements Interceptor,
PreResultListener {
    private static final long serialVersionUID = -8587579255675690482L;
    private static final Log LOG = LogFactory.getLog((Class)ScopeInterceptor.class);
    String[] application = null;
    String[] session = null;
    String key;
    String type = null;
    boolean autoCreateSession = true;
    String sessionReset = "session.reset";
    boolean reset = false;
    private static final Object NULL = new Serializable(){

        public String toString() {
            return "NULL";
        }
    };
    private static Map locks = new IdentityHashMap();

    public void setApplication(String s) {
        if (s != null) {
            this.application = s.split(" *, *");
        }
    }

    public void setSession(String s) {
        if (s != null) {
            this.session = s.split(" *, *");
        }
    }

    public void setAutoCreateSession(String value) {
        if (value != null && value.length() > 0) {
            this.autoCreateSession = new Boolean(value);
        }
    }

    private String getKey(ActionInvocation invocation) {
        ActionProxy proxy = invocation.getProxy();
        if (this.key == null || "CLASS".equals(this.key)) {
            return "webwork.ScopeInterceptor:" + proxy.getAction().getClass();
        }
        if ("ACTION".equals(this.key)) {
            return "webwork.ScopeInterceptor:" + proxy.getNamespace() + ":" + proxy.getActionName();
        }
        return this.key;
    }

    private static final Object nullConvert(Object o) {
        if (o == null) {
            return NULL;
        }
        if (o == NULL) {
            return null;
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void lock(Object o, ActionInvocation invocation) throws Exception {
        Object object = o;
        synchronized (object) {
            int count = 3;
            Object previous = null;
            while (true) {
                Object v = locks.get(o);
                previous = v;
                if (v == null) break;
                if (previous == invocation) {
                    return;
                }
                if (count-- <= 0) {
                    locks.remove(o);
                    o.notify();
                    throw new WebWorkException("Deadlock in session lock");
                }
                o.wait(10000L);
            }
            locks.put(o, invocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void unlock(Object o) {
        Object object = o;
        synchronized (object) {
            locks.remove(o);
            o.notify();
        }
    }

    protected void after(ActionInvocation invocation, String result) throws Exception {
        Map ses = ActionContext.getContext().getSession();
        if (ses != null) {
            ScopeInterceptor.unlock(ses);
        }
    }

    protected void before(ActionInvocation invocation) throws Exception {
        Object attribute;
        String string;
        int i;
        invocation.addPreResultListener((PreResultListener)this);
        Map ses = ActionContext.getContext().getSession();
        if (ses == null && this.autoCreateSession) {
            ses = new SessionMap(ServletActionContext.getRequest());
            ActionContext.getContext().setSession(ses);
        }
        if (ses != null) {
            ScopeInterceptor.lock(ses, invocation);
        }
        String key = this.getKey(invocation);
        Map app = ActionContext.getContext().getApplication();
        OgnlValueStack stack = ActionContext.getContext().getValueStack();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"scope interceptor before");
        }
        if (this.application != null) {
            for (i = 0; i < this.application.length; ++i) {
                string = this.application[i];
                attribute = app.get(key + string);
                if (attribute == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("application scoped variable set " + string + " = " + String.valueOf(attribute)));
                }
                stack.setValue(string, ScopeInterceptor.nullConvert(attribute));
            }
        }
        if (ActionContext.getContext().getParameters().get(this.sessionReset) != null) {
            return;
        }
        if (this.reset) {
            return;
        }
        if (ses == null) {
            LOG.warn((Object)"No HttpSession created... Cannot set session scoped variables");
            return;
        }
        if (this.session != null && !"start".equals(this.type)) {
            for (i = 0; i < this.session.length; ++i) {
                string = this.session[i];
                attribute = ses.get(key + string);
                if (attribute == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("session scoped variable set " + string + " = " + String.valueOf(attribute)));
                }
                stack.setValue(string, ScopeInterceptor.nullConvert(attribute));
            }
        }
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void beforeResult(ActionInvocation invocation, String resultCode) {
        String key = this.getKey(invocation);
        Map app = ActionContext.getContext().getApplication();
        OgnlValueStack stack = ActionContext.getContext().getValueStack();
        if (this.application != null) {
            for (int i = 0; i < this.application.length; ++i) {
                String string = this.application[i];
                Object value = stack.findValue(string);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("application scoped variable saved " + string + " = " + String.valueOf(value)));
                }
                app.put(key + string, ScopeInterceptor.nullConvert(value));
            }
        }
        boolean ends = "end".equals(this.type);
        Map ses = ActionContext.getContext().getSession();
        if (ses != null) {
            if (this.session != null) {
                for (int i = 0; i < this.session.length; ++i) {
                    String string = this.session[i];
                    if (ends) {
                        ses.remove(key + string);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("session scoped variable removed key=[" + key + string + "]"));
                        continue;
                    }
                    Object value = stack.findValue(string);
                    ses.put(key + string, ScopeInterceptor.nullConvert(value));
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("session scoped variable saved " + string + " = " + String.valueOf(value)));
                }
            }
            ScopeInterceptor.unlock(ses);
        } else {
            LOG.debug((Object)"No HttpSession created... Cannot save session scoped variables.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"scope interceptor after (before result)");
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (!"start".equals(type = type.toLowerCase()) && !"end".equals(type)) {
            throw new IllegalArgumentException("Only start or end are allowed arguments for type");
        }
        this.type = type;
    }

    public String getSessionReset() {
        return this.sessionReset;
    }

    public void setSessionReset(String sessionReset) {
        this.sessionReset = sessionReset;
    }

    public void destroy() {
    }

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String intercept(ActionInvocation invocation) throws Exception {
        String result = null;
        Map ses = ActionContext.getContext().getSession();
        this.before(invocation);
        try {
            result = invocation.invoke();
            this.after(invocation, result);
        }
        finally {
            if (ses != null) {
                ScopeInterceptor.unlock(ses);
            }
        }
        return result;
    }

    public boolean isReset() {
        return this.reset;
    }

    public void setReset(boolean reset) {
        this.reset = reset;
    }
}

