/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher;

import com.opensymphony.webwork.dispatcher.WebWorkResultSupport;
import com.opensymphony.webwork.dispatcher.mapper.ActionMapperFactory;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServletRedirectResult
extends WebWorkResultSupport {
    private static final long serialVersionUID = -4787182693920514194L;
    private static final Log log = LogFactory.getLog((Class)ServletRedirectResult.class);
    protected boolean prependServletContext = true;

    public void setPrependServletContext(boolean prependServletContext) {
        this.prependServletContext = prependServletContext;
    }

    protected void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        ActionContext ctx = invocation.getInvocationContext();
        HttpServletRequest request = (HttpServletRequest)ctx.get((Object)"com.opensymphony.xwork.dispatcher.HttpServletRequest");
        HttpServletResponse response = (HttpServletResponse)ctx.get((Object)"com.opensymphony.xwork.dispatcher.HttpServletResponse");
        if (ServletRedirectResult.isPathUrl(finalLocation)) {
            if (!finalLocation.startsWith("/")) {
                String namespace = ActionMapperFactory.getMapper().getMapping(request).getNamespace();
                finalLocation = namespace != null && namespace.length() > 0 && !"/".equals(namespace) ? namespace + "/" + finalLocation : "/" + finalLocation;
            }
            if (this.prependServletContext && request.getContextPath() != null && request.getContextPath().length() > 0) {
                finalLocation = request.getContextPath() + finalLocation;
            }
            finalLocation = response.encodeRedirectURL(finalLocation);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Redirecting to finalLocation " + finalLocation));
        }
        response.sendRedirect(finalLocation);
    }

    private static boolean isPathUrl(String url) {
        return url.indexOf(58) == -1;
    }
}

