/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.plexus;

import com.opensymphony.webwork.plexus.PlexusObjectFactory;
import com.opensymphony.webwork.plexus.PlexusThreadLocal;
import com.opensymphony.webwork.plexus.PlexusUtils;
import java.io.IOException;
import java.util.Collections;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.PlexusContainer;

public class PlexusFilter
implements Filter {
    private static final Log log = LogFactory.getLog((Class)PlexusObjectFactory.class);
    public static boolean loaded = false;
    private ServletContext ctx;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.ctx = filterConfig.getServletContext();
        loaded = true;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        PlexusContainer child = null;
        try {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpSession session = request.getSession(false);
            PlexusContainer parent = session != null ? (PlexusContainer)session.getAttribute("webwork.plexus.container") : (PlexusContainer)this.ctx.getAttribute("webwork.plexus.container");
            child = parent.createChildContainer("request", Collections.EMPTY_LIST, Collections.EMPTY_MAP);
            PlexusUtils.configure(child, "plexus-request.xml");
            child.initialize();
            child.start();
            PlexusThreadLocal.setPlexusContainer(child);
        }
        catch (Exception e) {
            log.error((Object)"Error initializing plexus container (scope: request)", (Throwable)e);
        }
        chain.doFilter(req, res);
        try {
            if (child != null) {
                child.dispose();
            }
            PlexusThreadLocal.setPlexusContainer(null);
        }
        catch (Exception e) {
            log.error((Object)"Error disposing plexus container (scope: request)", (Throwable)e);
        }
    }

    public void destroy() {
    }
}

