/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.freemarker;

import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.dispatcher.WebWorkResultSupport;
import com.opensymphony.webwork.views.freemarker.FreemarkerManager;
import com.opensymphony.webwork.views.util.ResourceUtil;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.LocaleProvider;
import com.opensymphony.xwork.util.OgnlValueStack;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FreemarkerResult
extends WebWorkResultSupport {
    private static final long serialVersionUID = -3778230771704661631L;
    protected ActionInvocation invocation;
    protected Configuration configuration;
    protected ObjectWrapper wrapper;
    protected String location;
    private String pContentType = "text/html";

    public void setContentType(String aContentType) {
        this.pContentType = aContentType;
    }

    public String getContentType() {
        return this.pContentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute(String location, ActionInvocation invocation) throws IOException, TemplateException {
        TemplateModel model;
        Template template;
        this.location = location;
        this.invocation = invocation;
        this.configuration = this.getConfiguration();
        this.wrapper = this.getObjectWrapper();
        if (!location.startsWith("/")) {
            ActionContext ctx = invocation.getInvocationContext();
            HttpServletRequest req = (HttpServletRequest)ctx.get((Object)"com.opensymphony.xwork.dispatcher.HttpServletRequest");
            String base = ResourceUtil.getResourceBase(req);
            location = base + "/" + location;
        }
        if (this.preTemplateProcess(template = this.configuration.getTemplate(location, this.deduceLocale()), model = this.createModel())) {
            try {
                Writer writer = null;
                boolean useOutputStream = false;
                try {
                    writer = this.getWriter();
                }
                catch (IllegalStateException ise) {
                    useOutputStream = true;
                }
                if (useOutputStream) {
                    writer = new StringWriter();
                    template.process((Object)model, writer);
                    ServletOutputStream os = ServletActionContext.getResponse().getOutputStream();
                    os.write(writer.toString().getBytes());
                } else {
                    template.process((Object)model, writer);
                }
            }
            finally {
                this.postTemplateProcess(template, model);
            }
        }
    }

    protected Configuration getConfiguration() throws TemplateException {
        return FreemarkerManager.getInstance().getConfiguration(ServletActionContext.getServletContext());
    }

    protected ObjectWrapper getObjectWrapper() {
        return this.configuration.getObjectWrapper();
    }

    protected Writer getWriter() throws IOException {
        return ServletActionContext.getResponse().getWriter();
    }

    protected TemplateModel createModel() throws TemplateModelException {
        ServletContext servletContext = ServletActionContext.getServletContext();
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        OgnlValueStack stack = ServletActionContext.getContext().getValueStack();
        Object action = null;
        if (this.invocation != null) {
            action = this.invocation.getAction();
        }
        return FreemarkerManager.getInstance().buildTemplateModel(stack, action, servletContext, request, response, this.wrapper);
    }

    protected Locale deduceLocale() {
        if (this.invocation.getAction() instanceof LocaleProvider) {
            return ((LocaleProvider)this.invocation.getAction()).getLocale();
        }
        return this.configuration.getLocale();
    }

    protected void postTemplateProcess(Template template, TemplateModel data) throws IOException {
    }

    protected boolean preTemplateProcess(Template template, TemplateModel model) throws IOException {
        Object attrContentType = template.getCustomAttribute("content_type");
        if (attrContentType != null) {
            ServletActionContext.getResponse().setContentType(attrContentType.toString());
        } else {
            String encoding;
            String contentType = this.getContentType();
            if (contentType == null) {
                contentType = "text/html";
            }
            if ((encoding = template.getEncoding()) != null) {
                contentType = contentType + "; charset=" + encoding;
            }
            ServletActionContext.getResponse().setContentType(contentType);
        }
        return true;
    }
}

