/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.freemarker;

import com.opensymphony.util.FileManager;
import com.opensymphony.webwork.views.JspSupportServlet;
import com.opensymphony.webwork.views.freemarker.ScopesHashModel;
import com.opensymphony.webwork.views.freemarker.WebWorkBeanWrapper;
import com.opensymphony.webwork.views.freemarker.WebWorkClassTemplateLoader;
import com.opensymphony.webwork.views.freemarker.tags.WebWorkModels;
import com.opensymphony.webwork.views.util.ContextUtil;
import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.util.OgnlValueStack;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.cache.WebappTemplateLoader;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.jsp.TaglibFactory;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.ext.servlet.HttpRequestParametersHashModel;
import freemarker.ext.servlet.HttpSessionHashModel;
import freemarker.ext.servlet.ServletContextHashModel;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javax.servlet.GenericServlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FreemarkerManager {
    private static final Log log = LogFactory.getLog((Class)FreemarkerManager.class);
    public static final String CONFIG_SERVLET_CONTEXT_KEY = "freemarker.Configuration";
    public static final String KEY_EXCEPTION = "exception";
    private static final String ATTR_APPLICATION_MODEL = ".freemarker.Application";
    private static final String ATTR_JSP_TAGLIBS_MODEL = ".freemarker.JspTaglibs";
    private static final String ATTR_SESSION_MODEL = ".freemarker.Session";
    private static final String ATTR_REQUEST_MODEL = ".freemarker.Request";
    private static final String ATTR_REQUEST_PARAMETERS_MODEL = ".freemarker.RequestParameters";
    public static final String KEY_APPLICATION = "Application";
    public static final String KEY_REQUEST_MODEL = "Request";
    public static final String KEY_SESSION_MODEL = "Session";
    public static final String KEY_JSP_TAGLIBS = "JspTaglibs";
    public static final String KEY_REQUEST_PARAMETER_MODEL = "Parameters";
    private static FreemarkerManager instance = null;

    public static final synchronized FreemarkerManager getInstance() {
        if (instance == null) {
            String classname = FreemarkerManager.class.getName();
            if (com.opensymphony.webwork.config.Configuration.isSet("webwork.freemarker.manager.classname")) {
                classname = com.opensymphony.webwork.config.Configuration.getString("webwork.freemarker.manager.classname").trim();
            }
            try {
                log.info((Object)("Instantiating Freemarker ConfigManager!, " + classname));
                instance = (FreemarkerManager)ObjectFactory.getObjectFactory().buildBean(classname, null);
            }
            catch (Exception e) {
                log.fatal((Object)("Fatal exception occurred while trying to instantiate a Freemarker ConfigManager instance, " + classname), (Throwable)e);
            }
        }
        if (instance == null) {
            instance = new FreemarkerManager();
        }
        return instance;
    }

    public final synchronized Configuration getConfiguration(ServletContext servletContext) throws TemplateException {
        Configuration config = (Configuration)servletContext.getAttribute(CONFIG_SERVLET_CONTEXT_KEY);
        if (config == null) {
            config = this.createConfiguration(servletContext);
            servletContext.setAttribute(CONFIG_SERVLET_CONTEXT_KEY, (Object)config);
        }
        config.setWhitespaceStripping(true);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScopesHashModel buildScopesHashModel(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, ObjectWrapper wrapper, OgnlValueStack stack) {
        HttpRequestHashModel requestModel;
        ScopesHashModel model = new ScopesHashModel(wrapper, servletContext, request, stack);
        ServletContext servletContext2 = servletContext;
        synchronized (servletContext2) {
            JspSupportServlet servlet;
            ServletContextHashModel servletContextModel = (ServletContextHashModel)servletContext.getAttribute(ATTR_APPLICATION_MODEL);
            if (servletContextModel == null && (servlet = JspSupportServlet.jspSupportServlet) != null) {
                servletContextModel = new ServletContextHashModel((GenericServlet)servlet, wrapper);
                servletContext.setAttribute(ATTR_APPLICATION_MODEL, (Object)servletContextModel);
                TaglibFactory taglibs = new TaglibFactory(servletContext);
                servletContext.setAttribute(ATTR_JSP_TAGLIBS_MODEL, (Object)taglibs);
            }
            model.put(KEY_APPLICATION, servletContextModel);
            model.put(KEY_JSP_TAGLIBS, (TemplateModel)servletContext.getAttribute(ATTR_JSP_TAGLIBS_MODEL));
        }
        HttpSession session = request.getSession(false);
        if (session != null) {
            model.put(KEY_SESSION_MODEL, new HttpSessionHashModel(session, wrapper));
        }
        if ((requestModel = (HttpRequestHashModel)request.getAttribute(ATTR_REQUEST_MODEL)) == null || requestModel.getRequest() != request) {
            requestModel = new HttpRequestHashModel(request, response, wrapper);
            request.setAttribute(ATTR_REQUEST_MODEL, (Object)requestModel);
        }
        model.put(KEY_REQUEST_MODEL, requestModel);
        HttpRequestParametersHashModel reqParametersModel = (HttpRequestParametersHashModel)request.getAttribute(ATTR_REQUEST_PARAMETERS_MODEL);
        if (reqParametersModel == null || requestModel.getRequest() != request) {
            reqParametersModel = new HttpRequestParametersHashModel(request);
            request.setAttribute(ATTR_REQUEST_PARAMETERS_MODEL, (Object)reqParametersModel);
        }
        model.put(KEY_REQUEST_PARAMETER_MODEL, reqParametersModel);
        return model;
    }

    public void populateContext(ScopesHashModel model, OgnlValueStack stack, Object action, HttpServletRequest request, HttpServletResponse response) {
        Map standard = ContextUtil.getStandardContext(stack, request, response);
        model.putAll(standard);
        Throwable exception = (Throwable)request.getAttribute("javax.servlet.error.exception");
        if (exception == null) {
            exception = (Throwable)request.getAttribute("javax.servlet.error.JspException");
        }
        if (exception != null) {
            model.put(KEY_EXCEPTION, exception);
        }
    }

    protected BeansWrapper getObjectWrapper() {
        return new WebWorkBeanWrapper();
    }

    protected TemplateLoader getTemplateLoader(ServletContext servletContext) {
        FileTemplateLoader templatePathLoader = null;
        String templatePath = servletContext.getInitParameter("TemplatePath");
        if (templatePath == null) {
            templatePath = servletContext.getInitParameter("templatePath");
        }
        if (templatePath != null) {
            try {
                templatePathLoader = new FileTemplateLoader(new File(templatePath));
            }
            catch (IOException e) {
                log.error((Object)("Invalid template path specified: " + e.getMessage()), (Throwable)e);
            }
        }
        return templatePathLoader != null ? new MultiTemplateLoader(new TemplateLoader[]{templatePathLoader, new WebappTemplateLoader(servletContext), new WebWorkClassTemplateLoader()}) : new MultiTemplateLoader(new TemplateLoader[]{new WebappTemplateLoader(servletContext), new WebWorkClassTemplateLoader()});
    }

    protected Configuration createConfiguration(ServletContext servletContext) throws TemplateException {
        Configuration configuration = new Configuration();
        configuration.setTemplateLoader(this.getTemplateLoader(servletContext));
        configuration.setTemplateExceptionHandler(TemplateExceptionHandler.HTML_DEBUG_HANDLER);
        configuration.setObjectWrapper((ObjectWrapper)this.getObjectWrapper());
        if (com.opensymphony.webwork.config.Configuration.isSet("webwork.i18n.encoding")) {
            configuration.setDefaultEncoding(com.opensymphony.webwork.config.Configuration.getString("webwork.i18n.encoding"));
        }
        this.loadSettings(servletContext, configuration);
        return configuration;
    }

    protected void loadSettings(ServletContext servletContext, Configuration configuration) {
        try {
            InputStream in = FileManager.loadFile((String)"freemarker.properties", (Class)FreemarkerManager.class);
            if (in != null) {
                Properties p = new Properties();
                p.load(in);
                configuration.setSettings(p);
            }
        }
        catch (IOException e) {
            log.error((Object)"Error while loading freemarker settings from /freemarker.properties", (Throwable)e);
        }
        catch (TemplateException e) {
            log.error((Object)"Error while loading freemarker settings from /freemarker.properties", (Throwable)e);
        }
    }

    public SimpleHash buildTemplateModel(OgnlValueStack stack, Object action, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, ObjectWrapper wrapper) {
        ScopesHashModel model = this.buildScopesHashModel(servletContext, request, response, wrapper, stack);
        this.populateContext(model, stack, action, request, response);
        model.put("ww", new WebWorkModels(stack, request, response));
        return model;
    }
}

