/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.util.classloader.stores;

import com.opensymphony.webwork.util.classloader.stores.ResourceStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public final class FileResourceStore
implements ResourceStore {
    private final File root;

    public FileResourceStore(File pFile) {
        this.root = pFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read(String resourceName) {
        FileInputStream is = null;
        try {
            byte[] data;
            is = new FileInputStream(this.getFile(resourceName));
            byte[] byArray = data = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String resourceName, byte[] clazzData) {
        OutputStream os = null;
        try {
            File file = this.getFile(resourceName);
            File parent = file.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new IOException("could not create" + parent);
            }
            os = new FileOutputStream(file);
            os.write(clazzData);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void remove(String pResourceName) {
        this.getFile(pResourceName).delete();
    }

    private File getFile(String pResourceName) {
        String fileName = pResourceName.replace('.', File.separatorChar) + ".class";
        return new File(this.root, fileName);
    }
}

