/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.jsp.ui;

import com.opensymphony.webwork.components.AbstractRichtexteditorConnector;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.Result;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractRichtexteditorResult
implements Result {
    protected Document buildDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        return document;
    }

    protected Element buildCommonResponseXml(Document document, String command, String type, String folderPath, String serverPath) {
        Element connectorElement = document.createElement("Connector");
        connectorElement.setAttribute("command", command);
        connectorElement.setAttribute("resourceType", type);
        document.appendChild(connectorElement);
        Element myEl = document.createElement("CurrentFolder");
        myEl.setAttribute("path", folderPath);
        myEl.setAttribute("url", serverPath);
        connectorElement.appendChild(myEl);
        return connectorElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String stringFromDocument(Document document) throws TransformerConfigurationException, TransformerException {
        StringWriter writer = new StringWriter();
        String result = null;
        try {
            writer = new StringWriter();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(new DOMSource(document), new StreamResult(writer));
            result = writer.getBuffer().toString();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {}
            }
            writer = null;
        }
        return result;
    }

    protected void writeDocumentToStream(Document document, OutputStream out) throws TransformerConfigurationException, TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.transform(new DOMSource(document), new StreamResult(out));
    }

    protected String getCommand(ActionInvocation invocation) {
        return (String)invocation.getStack().getContext().get("__richtexteditorCommand");
    }

    protected String getType(ActionInvocation invocation) {
        return (String)invocation.getStack().getContext().get("__richtexteditorType");
    }

    protected String getFolderPath(ActionInvocation invocation) {
        return (String)invocation.getStack().getContext().get("__richtexteditorFolderPath");
    }

    protected String getServerPath(ActionInvocation invocation) {
        return (String)invocation.getStack().getContext().get("__richtexteditorServerPath");
    }

    protected AbstractRichtexteditorConnector.Folder[] richtexteditorFolders(ActionInvocation invocation) {
        return (AbstractRichtexteditorConnector.Folder[])invocation.getStack().getContext().get("__richtexteditorGetFolders");
    }

    protected AbstractRichtexteditorConnector.FoldersAndFiles richtexteditorFoldersAndFiles(ActionInvocation invocation) {
        return (AbstractRichtexteditorConnector.FoldersAndFiles)invocation.getStack().getContext().get("__richtexteditorGetFoldersAndFiles");
    }

    protected AbstractRichtexteditorConnector.CreateFolderResult richtexteditorCreateFolderResult(ActionInvocation invocation) {
        return (AbstractRichtexteditorConnector.CreateFolderResult)invocation.getStack().getContext().get("__richtexteditorCreateFolder");
    }

    protected AbstractRichtexteditorConnector.FileUploadResult richtexteditorFileUploadResult(ActionInvocation invocation) {
        return (AbstractRichtexteditorConnector.FileUploadResult)invocation.getStack().getContext().get("__richtexteditorFileUpload");
    }
}

