/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.xslt;

import com.opensymphony.webwork.views.xslt.AdapterNode;
import com.opensymphony.webwork.views.xslt.ArrayAdapter;
import com.opensymphony.webwork.views.xslt.BeanAdapter;
import com.opensymphony.webwork.views.xslt.CollectionAdapter;
import com.opensymphony.webwork.views.xslt.DefaultAdapterNode;
import com.opensymphony.webwork.views.xslt.DocumentAdapter;
import com.opensymphony.webwork.views.xslt.ToStringAdapter;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public class DOMAdapter {
    private Map index = new HashMap();
    private Pattern matchingPattern;
    private Pattern excludingPattern;
    static final transient Log LOG = LogFactory.getLog((Class)DOMAdapter.class);

    public short getNodeType() {
        return 7;
    }

    public String getPropertyName() {
        return "[Root]";
    }

    public boolean isAdaptable(DOMAdapter rootAdapter, Node parent, String propertyName) {
        boolean ret;
        if (this.matchingPattern == null && this.excludingPattern == null) {
            return true;
        }
        DefaultAdapterNode p = (DefaultAdapterNode)parent;
        StringBuffer buf = new StringBuffer();
        p.getPath(buf);
        buf.append('/').append(propertyName);
        boolean bl = ret = !(this.excludingPattern != null && this.excludingPattern.matcher(buf).matches() || this.matchingPattern != null && !this.matchingPattern.matcher(buf).matches());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("path adapt: " + buf + "=" + ret));
        }
        return ret;
    }

    public AdapterNode adapt(DOMAdapter rootAdapter, Node parent, String propertyName, Object value) {
        if (value == null) {
            LOG.warn((Object)("Property " + propertyName + " of " + parent + " is null"));
            return null;
        }
        Class<?> klass = value.getClass();
        Class adapterClass = this.findAdapterForClass(klass);
        try {
            RelationKey rk;
            Integer period;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("creating adapter for: " + ((AdapterNode)parent).getValue() + "," + propertyName + "," + value));
            }
            if ((period = (Integer)this.index.get(rk = new RelationKey(((AdapterNode)parent).getValue(), propertyName))) != null && ((AdapterNode)parent).getDepth() > period) {
                return null;
            }
            if (adapterClass == null) {
                adapterClass = klass.isArray() ? ArrayAdapter.class : (String.class.isAssignableFrom(klass) || klass.isPrimitive() || Number.class.isAssignableFrom(klass) ? ToStringAdapter.class : (Collection.class.isAssignableFrom(klass) ? CollectionAdapter.class : BeanAdapter.class));
            }
            Constructor c = adapterClass.getConstructor(DOMAdapter.class, AdapterNode.class, String.class, Object.class);
            AdapterNode adapter = (AdapterNode)c.newInstance(this, parent, propertyName, value);
            this.index.put(rk, new Integer(((AdapterNode)parent).getDepth()));
            return adapter;
        }
        catch (Exception e) {
            LOG.debug((Object)"Cannot adapt ", (Throwable)e);
            throw new RuntimeException("Cannot adapt " + parent + " (" + propertyName + ") ", e);
        }
    }

    public AdapterNode adapt(Object value) throws IllegalAccessException, InstantiationException {
        return new DocumentAdapter(this, null, "result", value);
    }

    public AdapterNode adaptNullValue(DOMAdapter rootAdapter, BeanAdapter parent, String propertyName) {
        return new ToStringAdapter(rootAdapter, parent, propertyName, "null");
    }

    private Class findAdapterForClass(Class klass) {
        return null;
    }

    public Pattern getMatchingPattern() {
        return this.matchingPattern;
    }

    public void setPattern(Pattern pattern, Pattern excludingPattern) {
        this.matchingPattern = pattern;
        this.excludingPattern = excludingPattern;
    }

    private static class RelationKey {
        Object parent;
        Object role;

        public RelationKey(Object parent, Object role) {
            this.parent = parent;
            this.role = role;
        }

        public boolean equals(Object arg0) {
            if (arg0 instanceof RelationKey) {
                RelationKey other = (RelationKey)arg0;
                return this.parent == other.parent && this.role.equals(other.role);
            }
            return false;
        }

        public int hashCode() {
            return System.identityHashCode(this.parent) ^ this.role.hashCode();
        }
    }
}

