/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher.multipart;

import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class JakartaMultiPartRequest
extends MultiPartRequest {
    private Map files = new HashMap();
    private Map params = new HashMap();
    private List errors = new ArrayList();

    public JakartaMultiPartRequest(HttpServletRequest servletRequest, String saveDir, int maxSize) throws IOException {
        DiskFileItemFactory fac = new DiskFileItemFactory();
        fac.setSizeThreshold(0);
        if (saveDir != null) {
            fac.setRepository(new File(saveDir));
        }
        try {
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)fac);
            List items = upload.parseRequest(this.createRequestContext(servletRequest));
            for (int i = 0; i < items.size(); ++i) {
                List values;
                FileItem item = (FileItem)items.get(i);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found item " + item.getFieldName()));
                }
                if (item.isFormField()) {
                    log.debug((Object)"Item is a normal form field");
                    values = this.params.get(item.getFieldName()) != null ? (List)this.params.get(item.getFieldName()) : new ArrayList();
                    String charset = servletRequest.getCharacterEncoding();
                    if (charset != null) {
                        values.add(item.getString(charset));
                    } else {
                        values.add(item.getString());
                    }
                    this.params.put(item.getFieldName(), values);
                    continue;
                }
                if (item.getSize() == 0L) {
                    log.warn((Object)"Item is a file upload of 0 size, ignoring");
                    continue;
                }
                log.debug((Object)"Item is a file upload");
                values = this.files.get(item.getFieldName()) != null ? (List)this.files.get(item.getFieldName()) : new ArrayList();
                values.add(item);
                this.files.put(item.getFieldName(), values);
            }
        }
        catch (FileUploadException e) {
            log.error((Object)e);
            this.errors.add(e.getMessage());
        }
    }

    public Enumeration getFileParameterNames() {
        return Collections.enumeration(this.files.keySet());
    }

    public String[] getContentType(String fieldName) {
        List items = (List)this.files.get(fieldName);
        if (items == null) {
            return null;
        }
        ArrayList<String> contentTypes = new ArrayList<String>(items.size());
        for (int i = 0; i < items.size(); ++i) {
            FileItem fileItem = (FileItem)items.get(i);
            contentTypes.add(fileItem.getContentType());
        }
        return contentTypes.toArray(new String[contentTypes.size()]);
    }

    public File[] getFile(String fieldName) {
        List items = (List)this.files.get(fieldName);
        if (items == null) {
            return null;
        }
        ArrayList<File> fileList = new ArrayList<File>(items.size());
        for (int i = 0; i < items.size(); ++i) {
            DiskFileItem fileItem = (DiskFileItem)items.get(i);
            fileList.add(fileItem.getStoreLocation());
        }
        return fileList.toArray(new File[fileList.size()]);
    }

    public String[] getFileNames(String fieldName) {
        List items = (List)this.files.get(fieldName);
        if (items == null) {
            return null;
        }
        ArrayList<String> fileNames = new ArrayList<String>(items.size());
        for (int i = 0; i < items.size(); ++i) {
            DiskFileItem fileItem = (DiskFileItem)items.get(i);
            fileNames.add(this.getCanonicalName(fileItem.getName()));
        }
        return fileNames.toArray(new String[fileNames.size()]);
    }

    public String[] getFilesystemName(String fieldName) {
        List items = (List)this.files.get(fieldName);
        if (items == null) {
            return null;
        }
        ArrayList<String> fileNames = new ArrayList<String>(items.size());
        for (int i = 0; i < items.size(); ++i) {
            DiskFileItem fileItem = (DiskFileItem)items.get(i);
            fileNames.add(fileItem.getStoreLocation().getName());
        }
        return fileNames.toArray(new String[fileNames.size()]);
    }

    public String getParameter(String name) {
        List v = (List)this.params.get(name);
        if (v != null && v.size() > 0) {
            return (String)v.get(0);
        }
        return null;
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.params.keySet());
    }

    public String[] getParameterValues(String name) {
        List v = (List)this.params.get(name);
        if (v != null && v.size() > 0) {
            return v.toArray(new String[v.size()]);
        }
        return null;
    }

    public List getErrors() {
        return this.errors;
    }

    private String getCanonicalName(String filename) {
        int forwardSlash = filename.lastIndexOf("/");
        int backwardSlash = filename.lastIndexOf("\\");
        if (forwardSlash != -1 && forwardSlash > backwardSlash) {
            filename = filename.substring(forwardSlash + 1, filename.length());
        } else if (backwardSlash != -1 && backwardSlash >= forwardSlash) {
            filename = filename.substring(backwardSlash + 1, filename.length());
        }
        return filename;
    }

    private RequestContext createRequestContext(final HttpServletRequest req) {
        return new RequestContext(){

            public String getCharacterEncoding() {
                return req.getCharacterEncoding();
            }

            public String getContentType() {
                return req.getContentType();
            }

            public int getContentLength() {
                return req.getContentLength();
            }

            public InputStream getInputStream() throws IOException {
                return req.getInputStream();
            }
        };
    }
}

