/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher;

import com.opensymphony.webwork.dispatcher.WebWorkResultSupport;
import com.opensymphony.xwork.ActionInvocation;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StreamResult
extends WebWorkResultSupport {
    protected static final Log log = LogFactory.getLog((Class)StreamResult.class);
    protected String contentType = "text/plain";
    protected int contentLength;
    protected String contentDisposition = "inline";
    protected String inputName = "inputStream";
    protected int bufferSize = 1024;

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public void setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
    }

    public String getInputName() {
        return this.inputName;
    }

    public void setInputName(String inputName) {
        this.inputName = inputName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        InputStream oInput = null;
        OutputStream oOutput = null;
        try {
            int iSize;
            oInput = (InputStream)invocation.getStack().findValue(this.conditionalParse(this.inputName, invocation));
            if (oInput == null) {
                String msg = "Can not find a java.io.InputStream with the name [" + this.inputName + "] in the invocation stack. " + "Check the <param name=\"inputName\"> tag specified for this action.";
                log.error((Object)msg);
                throw new IllegalArgumentException(msg);
            }
            HttpServletResponse oResponse = (HttpServletResponse)invocation.getInvocationContext().get((Object)"com.opensymphony.xwork.dispatcher.HttpServletResponse");
            oResponse.setContentType(this.conditionalParse(this.contentType, invocation));
            if (this.contentLength != 0) {
                oResponse.setContentLength(this.contentLength);
            }
            if (this.contentDisposition != null) {
                oResponse.addHeader("Content-disposition", this.conditionalParse(this.contentDisposition, invocation));
            }
            oOutput = oResponse.getOutputStream();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Streaming result [" + this.inputName + "] type=[" + this.contentType + "] length=[" + this.contentLength + "] content-disposition=[" + this.contentDisposition + "]"));
            }
            log.debug((Object)"Streaming to output buffer +++ START +++");
            byte[] oBuff = new byte[this.bufferSize];
            while (-1 != (iSize = oInput.read(oBuff))) {
                oOutput.write(oBuff, 0, iSize);
            }
            log.debug((Object)"Streaming to output buffer +++ END +++");
            oOutput.flush();
        }
        finally {
            if (oInput != null) {
                oInput.close();
            }
            if (oOutput != null) {
                oOutput.close();
            }
        }
    }
}

