/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.jsp.ui;

import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.validators.JavaScriptVisitorFieldValidator;
import com.opensymphony.webwork.validators.ScriptValidationAware;
import com.opensymphony.webwork.views.jsp.ParameterizedTagSupport;
import com.opensymphony.webwork.views.jsp.ui.FormTag;
import com.opensymphony.webwork.views.jsp.ui.template.TemplateEngine;
import com.opensymphony.webwork.views.jsp.ui.template.TemplateEngineManager;
import com.opensymphony.webwork.views.jsp.ui.template.TemplateRenderingContext;
import com.opensymphony.xwork.ModelDriven;
import com.opensymphony.xwork.config.ConfigurationException;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.opensymphony.xwork.validator.ActionValidatorManager;
import com.opensymphony.xwork.validator.DelegatingValidatorContext;
import com.opensymphony.xwork.validator.FieldValidator;
import com.opensymphony.xwork.validator.Validator;
import com.opensymphony.xwork.validator.ValidatorContext;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import ognl.OgnlRuntime;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractUITag
extends ParameterizedTagSupport {
    private static final Log LOG = LogFactory.getLog(AbstractUITag.class);
    protected String cssClassAttr;
    protected String cssStyleAttr;
    protected String disabledAttr;
    protected String labelAttr;
    protected String labelPositionAttr;
    protected String nameAttr;
    protected String requiredAttr;
    protected String tabindexAttr;
    protected String templateAttr;
    protected String templateDir;
    protected String theme;
    protected String themeAttr;
    protected String valueAttr;
    protected String onclickAttr;
    protected String ondblclickAttr;
    protected String onmousedownAttr;
    protected String onmouseupAttr;
    protected String onmouseoverAttr;
    protected String onmousemoveAttr;
    protected String onmouseoutAttr;
    protected String onfocusAttr;
    protected String onblurAttr;
    protected String onkeypressAttr;
    protected String onkeydownAttr;
    protected String onkeyupAttr;
    protected String onselectAttr;
    protected String onchangeAttr;

    public void setCssClass(String aCssClass) {
        this.cssClassAttr = aCssClass;
    }

    public void setCssStyle(String aCssStyle) {
        this.cssStyleAttr = aCssStyle;
    }

    public void setDisabled(String disabled) {
        this.disabledAttr = disabled;
    }

    public void setLabel(String aLabel) {
        this.labelAttr = aLabel;
    }

    public void setLabelposition(String aLabelPosition) {
        this.labelPositionAttr = aLabelPosition;
    }

    public void setName(String aName) {
        this.nameAttr = aName;
    }

    public void setRequired(String required) {
        this.requiredAttr = required;
    }

    public void setTabindex(String tabindex) {
        this.tabindexAttr = tabindex;
    }

    public void setTemplate(String aName) {
        this.templateAttr = aName;
    }

    public String getTemplateDir() {
        if (this.templateDir == null || this.templateDir == "") {
            this.templateDir = this.setupPath((String)this.pageContext.findAttribute("templateDir"), true);
        }
        if (this.templateDir == null || this.templateDir == "") {
            this.templateDir = this.setupPath(Configuration.getString("webwork.ui.templateDir"), true);
        }
        if (this.templateDir == null || this.templateDir == "") {
            this.templateDir = "/template/";
        }
        return this.templateDir;
    }

    public void setTheme(String aName) {
        this.themeAttr = aName;
    }

    public String getTheme() {
        if (this.themeAttr != null) {
            this.theme = this.setupPath(this.findString(this.themeAttr), false);
        }
        if (this.theme == null || this.theme == "") {
            this.theme = this.setupPath((String)this.pageContext.findAttribute("theme"), false);
        }
        if (this.theme == null || this.theme == "") {
            this.theme = this.setupPath(Configuration.getString("webwork.ui.theme"), false);
        }
        return this.theme;
    }

    public void setValue(String aValue) {
        this.valueAttr = aValue;
    }

    public void setOnclick(String onclick) {
        this.onclickAttr = onclick;
    }

    public void setOndblclick(String ondblclick) {
        this.ondblclickAttr = ondblclick;
    }

    public void setOnmousedown(String onmousedown) {
        this.onmousedownAttr = onmousedown;
    }

    public void setOnmouseup(String onmouseup) {
        this.onmouseupAttr = onmouseup;
    }

    public void setOnmouseover(String onmouseover) {
        this.onmouseoverAttr = onmouseover;
    }

    public void setOnmousemove(String onmousemove) {
        this.onmousemoveAttr = onmousemove;
    }

    public void setOnmouseout(String onmouseout) {
        this.onmouseoutAttr = onmouseout;
    }

    public void setOnfocus(String onfocus) {
        this.onfocusAttr = onfocus;
    }

    public void setOnblur(String onblur) {
        this.onblurAttr = onblur;
    }

    public void setOnkeypress(String onkeypress) {
        this.onkeypressAttr = onkeypress;
    }

    public void setOnkeydown(String onkeydown) {
        this.onkeydownAttr = onkeydown;
    }

    public void setOnkeyup(String onkeyup) {
        this.onkeyupAttr = onkeyup;
    }

    public void setOnselect(String onselect) {
        this.onselectAttr = onselect;
    }

    public void setOnchange(String onchange) {
        this.onchangeAttr = onchange;
    }

    public int doEndTag() throws JspException {
        try {
            OgnlValueStack stack = this.getStack();
            this.evaluateParams(stack);
            try {
                this.mergeTemplate(this.getTemplateName());
                int n = 6;
                return n;
            }
            catch (Exception e) {
                throw new JspException("Fatal exception caught in " + this.getClass().getName() + " tag class, doEndTag: " + e.getMessage(), (Throwable)e);
            }
        }
        finally {
            this.reset();
        }
    }

    public int doStartTag() throws JspException {
        return 1;
    }

    protected abstract String getDefaultTemplate();

    protected String getTemplateName() {
        return this.buildTemplateName(this.templateAttr, this.getDefaultTemplate());
    }

    protected Class getValueClassType() {
        return String.class;
    }

    protected String buildTemplateName(String myTemplate, String myDefaultTemplate) {
        String template = myDefaultTemplate;
        if (myTemplate != null && (template = this.findString(myTemplate)) == null) {
            LOG.warn((Object)"template attribute evaluated to null; using value as-is for backwards compatibility");
            template = myTemplate;
        }
        return this.getTemplateDir() + this.getTheme() + template;
    }

    protected void evaluateExtraParams(OgnlValueStack stack) {
    }

    protected boolean evaluateNameValue() {
        return true;
    }

    protected void evaluateParams(OgnlValueStack stack) {
        FormTag formTag;
        String name = null;
        if (this.nameAttr != null) {
            name = this.findString(this.nameAttr);
            this.addParameter("name", name);
        }
        if (this.labelAttr != null) {
            this.addParameter("label", this.findString(this.labelAttr));
        }
        if (this.labelPositionAttr != null) {
            this.addParameter("labelposition", this.findString(this.labelPositionAttr));
        }
        if (this.requiredAttr != null) {
            this.addParameter("required", this.findValue(this.requiredAttr, Boolean.class));
        }
        if (this.disabledAttr != null) {
            this.addParameter("disabled", this.findValue(this.disabledAttr, Boolean.class));
        }
        if (this.tabindexAttr != null) {
            this.addParameter("tabindex", this.findString(this.tabindexAttr));
        }
        if (this.onclickAttr != null) {
            this.addParameter("onclick", this.findString(this.onclickAttr));
        }
        if (this.ondblclickAttr != null) {
            this.addParameter("ondblclick", this.findString(this.ondblclickAttr));
        }
        if (this.onmousedownAttr != null) {
            this.addParameter("onmousedown", this.findString(this.onmousedownAttr));
        }
        if (this.onmouseupAttr != null) {
            this.addParameter("onmouseup", this.findString(this.onmouseupAttr));
        }
        if (this.onmouseoverAttr != null) {
            this.addParameter("onmouseover", this.findString(this.onmouseoverAttr));
        }
        if (this.onmousemoveAttr != null) {
            this.addParameter("onmousemove", this.findString(this.onmousemoveAttr));
        }
        if (this.onmouseoutAttr != null) {
            this.addParameter("onmouseout", this.findString(this.onmouseoutAttr));
        }
        if (this.onfocusAttr != null) {
            this.addParameter("onfocus", this.findString(this.onfocusAttr));
        }
        if (this.onblurAttr != null) {
            this.addParameter("onblur", this.findString(this.onblurAttr));
        }
        if (this.onkeypressAttr != null) {
            this.addParameter("onkeypress", this.findString(this.onkeypressAttr));
        }
        if (this.onkeydownAttr != null) {
            this.addParameter("onkeydown", this.findString(this.onkeydownAttr));
        }
        if (this.onkeyupAttr != null) {
            this.addParameter("onkeyup", this.findString(this.onkeyupAttr));
        }
        if (this.onselectAttr != null) {
            this.addParameter("onselect", this.findString(this.onselectAttr));
        }
        if (this.onchangeAttr != null) {
            this.addParameter("onchange", this.findString(this.onchangeAttr));
        }
        if (this.cssClassAttr != null) {
            this.addParameter("cssClass", this.findString(this.cssClassAttr));
        }
        if (this.cssStyleAttr != null) {
            this.addParameter("cssStyle", this.findString(this.cssStyleAttr));
        }
        if (this.evaluateNameValue()) {
            Class valueClazz = this.getValueClassType();
            if (valueClazz != null) {
                if (this.valueAttr != null) {
                    this.addParameter("nameValue", this.findValue(this.valueAttr, valueClazz));
                } else if (name != null) {
                    String expr = name.toString();
                    this.addParameter("nameValue", this.findValue(expr, valueClazz));
                }
            } else if (this.valueAttr != null) {
                this.addParameter("nameValue", this.findValue(this.valueAttr));
            } else if (name != null) {
                this.addParameter("nameValue", this.findValue(name.toString()));
            }
        }
        if (this.id != null) {
            this.addParameter("id", this.getId());
        }
        if ((formTag = (FormTag)AbstractUITag.findAncestorWithClass((Tag)this, FormTag.class)) != null) {
            this.addParameter("form", formTag.getParameters());
            Boolean validate = (Boolean)formTag.getParameters().get("validate");
            if (validate != null && validate.booleanValue() && formTag.getActionClass() != null && formTag.getActionName() != null && name != null) {
                this.findScriptingValidators(formTag, name, formTag.getActionClass(), null);
            }
        }
        this.evaluateExtraParams(stack);
    }

    protected void mergeTemplate(String templateName) throws Exception {
        TemplateEngine engine = TemplateEngineManager.getTemplateEngine(templateName);
        if (engine == null) {
            throw new ConfigurationException("Unable to find a TemplateEngine for template " + templateName);
        }
        String finalTemplateName = engine.getFinalTemplateName(templateName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Got template engine " + engine.getClass().getName() + " for template '" + templateName + "'" + (templateName.equals(finalTemplateName) ? null : " final template name '" + finalTemplateName + "'")));
        }
        TemplateRenderingContext context = new TemplateRenderingContext(finalTemplateName, this.pageContext, this.getStack(), this.getParameters(), this);
        engine.renderTemplate(context);
    }

    private void findScriptingValidators(FormTag formTag, String fieldName, Class fieldClass, String propertyName) {
        List validators = ActionValidatorManager.getValidators((Class)fieldClass, (String)formTag.getActionName());
        String name = fieldName;
        if (propertyName != null) {
            name = propertyName;
        }
        for (Validator validator : validators) {
            if (!(validator instanceof ScriptValidationAware)) continue;
            DelegatingValidatorContext validatorContext = new DelegatingValidatorContext(fieldClass);
            if (validator instanceof FieldValidator) {
                FieldValidator fieldValidator = (FieldValidator)validator;
                if (validator instanceof JavaScriptVisitorFieldValidator) {
                    boolean visit;
                    JavaScriptVisitorFieldValidator visitorValidator = (JavaScriptVisitorFieldValidator)validator;
                    String propName = null;
                    if (visitorValidator.getFieldName().equals("model") && ModelDriven.class.isAssignableFrom(fieldClass)) {
                        visit = true;
                    } else {
                        String baseName = name;
                        int idx = name.indexOf(".");
                        if (idx != -1) {
                            baseName = name.substring(0, idx);
                            propName = name.substring(idx + 1);
                        }
                        visit = baseName.equals(visitorValidator.getFieldName());
                    }
                    if (!visit) continue;
                    Class<?> realFieldClass = visitorValidator.getValidatedClass();
                    if (realFieldClass == null) {
                        for (Object o : this.getStack().getRoot()) {
                            try {
                                PropertyDescriptor pd = OgnlRuntime.getPropertyDescriptor(o.getClass(), (String)visitorValidator.getFieldName());
                                realFieldClass = pd.getPropertyType();
                                break;
                            }
                            catch (Throwable throwable) {
                            }
                        }
                    }
                    if (realFieldClass != null) {
                        if (visitorValidator.isAppendPrefix()) {
                            this.findScriptingValidators(formTag, visitorValidator.getFieldName() + "." + name, realFieldClass, propName);
                            continue;
                        }
                        this.findScriptingValidators(formTag, name, realFieldClass, propName);
                        continue;
                    }
                    LOG.warn((Object)"Cannot figure out class of visited object");
                    continue;
                }
                if (!fieldValidator.getFieldName().equals(name)) continue;
                validator.setValidatorContext((ValidatorContext)validatorContext);
                formTag.registerValidator((ScriptValidationAware)fieldValidator, new HashMap(this.getParameters()));
                continue;
            }
            validator.setValidatorContext((ValidatorContext)validatorContext);
            formTag.registerValidator((ScriptValidationAware)validator, new HashMap(this.getParameters()));
        }
    }

    private String setupPath(String path, boolean prefix) {
        if (path != null && path != "") {
            if (prefix && !path.startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith("/")) {
                path = path + "/";
            }
        }
        return path;
    }
}

