/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.jsp;

import com.opensymphony.webwork.config.Configuration;
import java.util.StringTokenizer;

public class CompatUtil {
    public static boolean compatMode = false;

    public static String compat(String expr) {
        if (compatMode) {
            boolean toggle = false;
            StringTokenizer st = new StringTokenizer(expr, "'", true);
            if (!st.hasMoreTokens()) {
                return CompatUtil.convert(expr);
            }
            StringBuffer sb = new StringBuffer();
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!token.equals("'")) {
                    if (toggle) {
                        sb.append(token);
                        continue;
                    }
                    sb.append(CompatUtil.convert(token));
                    continue;
                }
                sb.append('\'');
                toggle = !toggle;
            }
            return sb.toString();
        }
        return expr;
    }

    private static String convert(String expr) {
        expr = expr.replaceAll("\\.\\.", "[1]");
        expr = expr.replaceAll("\\.", "top");
        expr = expr.replaceAll("([^\\d\\/ ]+?)\\/([^\\d\\/ ]+?)", "$1\\.$2");
        expr = expr.replaceAll("\\@([^\\. \\[]+)", "#attr\\.get\\('$1'\\)");
        expr = expr.replaceAll("\\$([^\\. \\[]+)", "#parameters\\.get\\('$1'\\)");
        return expr;
    }

    static {
        if (Configuration.isSet("compatibility.mode")) {
            compatMode = "true".equals(Configuration.getString("compatibility.mode"));
        }
    }
}

