/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.freemarker;

import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ScopesHashModel
extends SimpleHash {
    private HttpServletRequest request;
    private ObjectWrapper objectWraper;
    private ServletContext servletContext;

    public ScopesHashModel(ObjectWrapper objectWrapper, ServletContext context, HttpServletRequest request) {
        this.objectWraper = objectWrapper;
        this.servletContext = context;
        this.request = request;
    }

    public TemplateModel get(String key) throws TemplateModelException {
        Object obj;
        TemplateModel model = super.get(key);
        if (model != null) {
            return model;
        }
        if (this.request != null) {
            obj = this.request.getAttribute(key);
            if (obj != null) {
                return this.objectWraper.wrap(obj);
            }
            HttpSession session = this.request.getSession(false);
            if (session != null && (obj = session.getAttribute(key)) != null) {
                return this.objectWraper.wrap(obj);
            }
        }
        if (this.servletContext != null && (obj = this.servletContext.getAttribute(key)) != null) {
            return this.objectWraper.wrap(obj);
        }
        return null;
    }
}

