/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.velocity;

import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.util.VelocityWebWorkUtil;
import com.opensymphony.webwork.views.jsp.ui.OgnlTool;
import com.opensymphony.webwork.views.velocity.WebWorkVelocityContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityManager {
    private static final Log log = LogFactory.getLog(VelocityManager.class);
    private static VelocityManager instance;
    public static final String REQUEST = "req";
    public static final String RESPONSE = "res";
    public static final String STACK = "stack";
    public static final String OGNL = "ognl";
    public static final String WEBWORK = "webwork";
    public static final String ACTION = "action";
    public static final String PARENT = "parent";
    public static final String TAG = "tag";
    private OgnlTool ognlTool = OgnlTool.getInstance();
    private VelocityEngine velocityEngine;
    private VelocityContext[] chainedContexts;

    protected VelocityManager() {
        this.init();
    }

    public static synchronized VelocityManager getInstance() {
        if (instance == null) {
            String classname = VelocityManager.class.getName();
            if (Configuration.isSet("webwork.velocity.manager.classname")) {
                classname = Configuration.getString("webwork.velocity.manager.classname").trim();
            }
            if (!classname.equals(VelocityManager.class.getName())) {
                try {
                    log.info((Object)("Instantiating VelocityManager!, " + classname));
                    instance = (VelocityManager)ObjectFactory.getObjectFactory().buildBean(Class.forName(classname));
                }
                catch (Exception e) {
                    log.fatal((Object)("Fatal exception occurred while trying to instantiate a VelocityManager instance, " + classname), (Throwable)e);
                    instance = new VelocityManager();
                }
            } else {
                instance = new VelocityManager();
            }
        }
        return instance;
    }

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public Context createContext(OgnlValueStack stack, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        WebWorkVelocityContext context = new WebWorkVelocityContext(this.chainedContexts, stack);
        context.put(REQUEST, servletRequest);
        context.put(RESPONSE, servletResponse);
        context.put(STACK, stack);
        context.put(OGNL, this.ognlTool);
        context.put(WEBWORK, new VelocityWebWorkUtil((Context)context, stack, servletRequest, servletResponse));
        ActionInvocation invocation = (ActionInvocation)stack.getContext().get("com.opensymphony.xwork.ActionContext.actionInvocation");
        if (invocation != null) {
            context.put(ACTION, invocation.getAction());
        }
        return context;
    }

    public synchronized void init(ServletContext context) {
        if (this.velocityEngine == null) {
            this.velocityEngine = this.newVelocityEngine(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadConfiguration(ServletContext context) {
        if (context == null) {
            String gripe = "Error attempting to create a loadConfiguration from a null ServletContext!";
            log.error((Object)gripe);
            throw new IllegalArgumentException(gripe);
        }
        Properties properties = new Properties();
        this.applyDefaultConfiguration(context, properties);
        String configfile = Configuration.isSet("webwork.velocity.configfile") ? Configuration.getString("webwork.velocity.configfile") : "velocity.properties";
        configfile = configfile.trim();
        InputStream in = null;
        try {
            String filename;
            if (context.getRealPath(configfile) != null && (filename = context.getRealPath(configfile)) != null) {
                File file;
                File file2 = new File(filename);
                if (file2.isFile()) {
                    in = new FileInputStream(file2);
                }
                if (in == null && (file = new File(context.getRealPath("/WEB-INF/" + configfile))).isFile()) {
                    in = new FileInputStream(file);
                }
            }
            if (in == null) {
                in = VelocityManager.class.getClassLoader().getResourceAsStream(configfile);
            }
            if (in != null) {
                log.info((Object)("Initializing velocity using '" + configfile + "'"));
                properties.load(in);
            }
        }
        catch (IOException e) {
            log.warn((Object)("Unable to load velocity configuration file '" + configfile + "'"), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing Velocity with the following properties ...");
            for (String string : properties.keySet()) {
                String value = properties.getProperty(string);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("    '" + string + "' = '" + value + "'"));
            }
        }
        return properties;
    }

    protected void init() {
        if (Configuration.isSet("webwork.velocity.contexts")) {
            String contexts = Configuration.get("webwork.velocity.contexts").toString();
            StringTokenizer st = new StringTokenizer(contexts, ",");
            ArrayList<VelocityContext> contextList = new ArrayList<VelocityContext>();
            while (st.hasMoreTokens()) {
                String classname = st.nextToken();
                try {
                    VelocityContext velocityContext = (VelocityContext)ObjectFactory.getObjectFactory().buildBean(Class.forName(classname));
                    contextList.add(velocityContext);
                }
                catch (Exception e) {
                    log.warn((Object)("Warning.  " + e.getClass().getName() + " caught while attempting to instantiate a chained VelocityContext, " + classname + " -- skipping"));
                }
            }
            if (contextList.size() > 0) {
                VelocityContext[] chainedContexts = new VelocityContext[contextList.size()];
                contextList.toArray(chainedContexts);
                this.chainedContexts = chainedContexts;
            } else {
                this.chainedContexts = null;
            }
        }
    }

    protected VelocityEngine newVelocityEngine(ServletContext context) {
        if (context == null) {
            String gripe = "Error attempting to create a new VelocityEngine from a null ServletContext!";
            log.error((Object)gripe);
            throw new IllegalArgumentException(gripe);
        }
        Properties p = this.loadConfiguration(context);
        VelocityEngine velocityEngine = new VelocityEngine();
        try {
            velocityEngine.init(p);
        }
        catch (Exception e) {
            String gripe = "Unable to instantiate VelocityEngine!";
            log.error((Object)gripe, (Throwable)e);
            throw new RuntimeException(gripe);
        }
        return velocityEngine;
    }

    private void applyDefaultConfiguration(ServletContext context, Properties p) {
        if (p.getProperty("resource.loader") == null) {
            p.setProperty("resource.loader", "wwfile, wwclass");
        }
        if (context.getRealPath("") != null) {
            p.setProperty("wwfile.resource.loader.description", "Velocity File Resource Loader");
            p.setProperty("wwfile.resource.loader.class", "org.apache.velocity.runtime.resource.loader.FileResourceLoader");
            p.setProperty("wwfile.resource.loader.path", context.getRealPath(""));
            p.setProperty("wwfile.resource.loader.modificationCheckInterval", "2");
            p.setProperty("wwfile.resource.loader.cache", "true");
        } else {
            String prop = p.getProperty("resource.loader");
            if (prop.indexOf("wwfile,") != -1) {
                prop = VelocityManager.replace(prop, "wwfile,", "");
            } else if (prop.indexOf(", wwfile") != -1) {
                prop = VelocityManager.replace(prop, ", wwfile", "");
            } else if (prop.indexOf("wwfile") != -1) {
                prop = VelocityManager.replace(prop, "wwfile", "");
            }
            p.setProperty("resource.loader", prop);
        }
        p.setProperty("wwclass.resource.loader.description", "Velocity Classpath Resource Loader");
        p.setProperty("wwclass.resource.loader.class", "com.opensymphony.webwork.views.velocity.WebWorkResourceLoader");
        p.setProperty("wwclass.resource.loader.modificationCheckInterval", "2");
        p.setProperty("wwclass.resource.loader.cache", "true");
        String userdirective = p.getProperty("userdirective");
        String directives = "com.opensymphony.webwork.views.velocity.ParamDirective,com.opensymphony.webwork.views.velocity.TagDirective,com.opensymphony.webwork.views.velocity.BodyTagDirective";
        userdirective = userdirective == null || userdirective.trim().equals("") ? directives : userdirective.trim() + "," + directives;
        p.setProperty("userdirective", userdirective);
    }

    private static final String replace(String string, String oldString, String newString) {
        if (string == null) {
            return null;
        }
        if (newString == null) {
            return string;
        }
        int i = 0;
        if ((i = string.indexOf(oldString, i)) >= 0) {
            char[] string2 = string.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuffer buf = new StringBuffer(string2.length);
            buf.append(string2, 0, i).append(newString2);
            int j = i += oLength;
            while ((i = string.indexOf(oldString, i)) > 0) {
                buf.append(string2, j, i - j).append(newString2);
                j = i += oLength;
            }
            buf.append(string2, j, string2.length - j);
            return buf.toString();
        }
        return string;
    }
}

