/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.jsp.ui.template;

import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.views.jsp.ui.template.JspTemplateEngine;
import com.opensymphony.webwork.views.jsp.ui.template.TemplateEngine;
import com.opensymphony.webwork.views.jsp.ui.template.VelocityTemplateEngine;
import java.util.HashMap;
import java.util.Map;

public class TemplateEngineManager {
    public static final String DEFAULT_TEMPLATE_TYPE_CONFIG_KEY = "webwork.ui.templateSuffix";
    private static final TemplateEngineManager MANAGER = new TemplateEngineManager();
    private static final String DEFAULT_TEMPLATE_TYPE = "vm";
    Map templateEngines = new HashMap();

    private TemplateEngineManager() {
        this.templateEngines.put(DEFAULT_TEMPLATE_TYPE, new VelocityTemplateEngine());
        this.templateEngines.put("jsp", new JspTemplateEngine());
    }

    public static void registerTemplateEngine(String templateExtension, TemplateEngine templateEngine) {
        TemplateEngineManager.MANAGER.templateEngines.put(templateExtension, templateEngine);
    }

    public static TemplateEngine getTemplateEngine(String templateName) {
        String templateType = DEFAULT_TEMPLATE_TYPE;
        if (templateName.indexOf(".") > 0) {
            templateType = templateName.substring(templateName.indexOf(".") + 1);
        } else if (Configuration.isSet(DEFAULT_TEMPLATE_TYPE_CONFIG_KEY)) {
            templateType = (String)Configuration.get(DEFAULT_TEMPLATE_TYPE_CONFIG_KEY);
        }
        return (TemplateEngine)TemplateEngineManager.MANAGER.templateEngines.get(templateType);
    }
}

