/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.jsp.ui;

import com.opensymphony.webwork.util.TabbedPane;
import com.opensymphony.webwork.views.jsp.ui.ComponentTag;
import java.util.Map;
import java.util.Vector;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;

public class TabbedPaneTag
extends ComponentTag {
    private static final String TEMPLATE = "tabbedpane";
    protected String contentName;
    protected TabbedPane tabPane;

    public int getColSpanLength() {
        return this.getTabAlign().compareToIgnoreCase("CENTER") == 0 ? this.getContent().size() + 2 : this.getContent().size() + 1;
    }

    public void setContent(Vector content) {
        this.tabPane.setContent(content);
    }

    public Vector getContent() {
        return this.tabPane.getContent();
    }

    public void setContentName(String contentName) {
        this.contentName = this.strVal(contentName);
        Object obj = this.findValue(this.contentName);
        if (obj instanceof Vector) {
            this.setContent((Vector)obj);
        }
    }

    public String getContentName() {
        return this.contentName;
    }

    public String getIndexLink() {
        return "TABBEDPANE_" + this.getId() + "_INDEX";
    }

    public void setPageContext(PageContext aPageContext) {
        this.tabPane = new TabbedPane(0);
        this.contentName = null;
        this.setSelectedIndex(0);
        this.setTabAlign("'CENTER'");
        super.setPageContext(aPageContext);
    }

    public void setSelectedIndex(int selectedIndex) {
        this.tabPane.setSelectedIndex(selectedIndex);
    }

    public int getSelectedIndex() {
        return this.tabPane.getSelectedIndex();
    }

    public String getSelectedUrl() {
        Map.Entry me = (Map.Entry)this.getContent().elementAt(this.getSelectedIndex());
        return me.getValue().toString();
    }

    public void setTabAlign(String tabAlign) {
        this.tabPane.setTabAlign(this.strVal(tabAlign));
    }

    public String getTabAlign() {
        return this.tabPane.getTabAlign();
    }

    public boolean compareNumbers(Number n1, Number n2) {
        return n1.longValue() == n2.longValue();
    }

    @Override
    public int doStartTag() throws JspException {
        String indexStr = this.pageContext.getRequest().getParameter(this.getIndexLink());
        if (indexStr != null) {
            try {
                int index = Integer.parseInt(indexStr);
                this.setSelectedIndex(index < 0 ? 0 : index);
            }
            catch (Exception e) {
                throw new JspTagException("TabbedPane Error: " + e.toString());
            }
        }
        return super.doStartTag();
    }

    public void release() {
        this.setSelectedIndex(0);
        if (this.getTabAlign() == null) {
            this.setTabAlign("'CENTER'");
        }
    }

    @Override
    protected String getDefaultTemplate() {
        return TEMPLATE;
    }

    protected String strVal(String objName) {
        try {
            return this.findString(objName);
        }
        catch (Exception e) {
            return objName;
        }
    }
}

