/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.util;

import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.util.ClassLoaderUtils;
import com.opensymphony.webwork.views.jsp.ui.OgnlTool;
import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebWorkUtil {
    protected static final Log log = LogFactory.getLog(WebWorkUtil.class);
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected Map classes = new Hashtable();
    protected OgnlTool ognl = OgnlTool.getInstance();
    protected OgnlValueStack stack;

    public WebWorkUtil(OgnlValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        this.stack = stack;
        this.request = request;
        this.response = response;
    }

    public Object bean(Object aName) throws Exception {
        String name = aName.toString();
        Class c = (Class)this.classes.get(name);
        if (c == null) {
            c = ClassLoaderUtils.loadClass(name, WebWorkUtil.class);
            this.classes.put(name, c);
        }
        return ObjectFactory.getObjectFactory().buildBean(c);
    }

    public Object findString(String name) {
        return this.stack.findValue(name, String.class);
    }

    public String include(Object aName) throws Exception {
        return this.include(aName, this.request, this.response);
    }

    public String include(Object aName, HttpServletRequest aRequest, HttpServletResponse aResponse) throws Exception {
        try {
            RequestDispatcher dispatcher = aRequest.getRequestDispatcher(aName.toString());
            if (dispatcher == null) {
                throw new IllegalArgumentException("Cannot find included file " + aName);
            }
            ResponseWrapper responseWrapper = new ResponseWrapper(aResponse);
            dispatcher.include((ServletRequest)aRequest, (ServletResponse)responseWrapper);
            return responseWrapper.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public String textToHtml(String s) {
        return TextUtils.plainTextToHtml((String)s);
    }

    public String urlEncode(String s) {
        return URLEncoder.encode(s);
    }

    static class ServletOutputStreamWrapper
    extends ServletOutputStream {
        StringWriter writer;

        ServletOutputStreamWrapper(StringWriter aWriter) {
            this.writer = aWriter;
        }

        public void write(int aByte) {
            this.writer.write(aByte);
        }
    }

    static class ResponseWrapper
    extends HttpServletResponseWrapper {
        StringWriter strout = new StringWriter();
        PrintWriter writer;
        ServletOutputStream sout = new ServletOutputStreamWrapper(this.strout);

        ResponseWrapper(HttpServletResponse aResponse) {
            super(aResponse);
            this.writer = new PrintWriter(this.strout);
        }

        public String getData() {
            this.writer.flush();
            return this.strout.toString();
        }

        public ServletOutputStream getOutputStream() {
            return this.sout;
        }

        public PrintWriter getWriter() throws IOException {
            return this.writer;
        }
    }
}

