/*
 * Copyright (c) 2002-2003 by OpenSymphony
 * All rights reserved.
 */
/*
 * Created on 19/04/2004
 */
package com.opensymphony.webwork.util;

import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.util.OgnlValueStack;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.CharArrayWriter;
import java.io.IOException;


/**
 * @author CameronBraid
 */
public class VelocityWebWorkUtil extends WebWorkUtil {
    //~ Instance fields ////////////////////////////////////////////////////////

    private Context ctx;

    //~ Constructors ///////////////////////////////////////////////////////////

    public VelocityWebWorkUtil(Context ctx, OgnlValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
        this.ctx = ctx;
    }

    //~ Methods ////////////////////////////////////////////////////////////////

    /**
     */
    public String evaluate(String expression) throws IOException, ResourceNotFoundException, MethodInvocationException, ParseErrorException {
        CharArrayWriter writer = new CharArrayWriter();
        Velocity.evaluate(ctx, writer, "Error parsing " + expression, expression);

        return writer.toString();
    }

    public String htmlEncode(Object obj) {
        if (obj == null) {
            return null;
        }

        return TextUtils.htmlEncode(obj.toString());
    }

    public int toInt(long aLong) {
        return (int) aLong;
    }

    public long toLong(int anInt) {
        return (long) anInt;
    }

    public long toLong(String aLong) {
        if (aLong == null) {
            return 0;
        }

        return Long.parseLong(aLong);
    }

    public String toString(long aLong) {
        return Long.toString(aLong);
    }

    public String toString(int anInt) {
        return Integer.toString(anInt);
    }
}
