/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.util;

import com.opensymphony.xwork.util.OgnlUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import ognl.Node;
import ognl.OgnlException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SafeExpressionUtil {
    private static final Set SAFE_EXPRESSIONS_CACHE = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Log log = LogFactory.getLog(SafeExpressionUtil.class);
    private static final Set UNSAFE_NODE_TYPES;
    private static final Set UNSAFE_PROPERTY_NAMES;
    private static final Set UNSAFE_METHOD_NAMES;
    private static final Set UNSAFE_VARIABLE_NAMES;

    public static boolean isSafeExpression(String expression) {
        if (!SAFE_EXPRESSIONS_CACHE.contains(expression)) {
            try {
                Object parsedExpression = OgnlUtil.compile((String)expression);
                if (parsedExpression instanceof Node) {
                    if (SafeExpressionUtil.containsUnsafeExpression((Node)parsedExpression)) {
                        String message = "Unsafe clause found in [" + expression + "]";
                        log.warn((Object)message);
                    } else {
                        SAFE_EXPRESSIONS_CACHE.add(expression);
                    }
                }
            }
            catch (OgnlException ex) {
                log.debug((Object)"Cannot verify safety of OGNL expression", (Throwable)ex);
            }
        }
        return SAFE_EXPRESSIONS_CACHE.contains(expression);
    }

    private static boolean containsUnsafeExpression(Node node) {
        String nodeClassName = node.getClass().getName();
        if (UNSAFE_NODE_TYPES.contains(nodeClassName)) {
            return true;
        }
        if ("ognl.ASTProperty".equals(nodeClassName) && UNSAFE_PROPERTY_NAMES.contains(node.toString())) {
            return true;
        }
        if ("ognl.ASTMethod".equals(nodeClassName) && UNSAFE_METHOD_NAMES.contains(node.toString())) {
            return true;
        }
        if ("ognl.ASTVarRef".equals(nodeClassName) && UNSAFE_VARIABLE_NAMES.contains(node.toString())) {
            return true;
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            Node childNode = node.jjtGetChild(i);
            if (childNode == null || !SafeExpressionUtil.containsUnsafeExpression(childNode)) continue;
            return true;
        }
        return false;
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add("ognl.ASTStaticMethod");
        set.add("ognl.ASTStaticField");
        set.add("ognl.ASTCtor");
        set.add("ognl.ASTAssign");
        UNSAFE_NODE_TYPES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add("class");
        set.add("classLoader");
        UNSAFE_PROPERTY_NAMES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add("getClass()");
        set.add("getClassLoader()");
        UNSAFE_METHOD_NAMES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add("#_memberAccess");
        set.add("#context");
        set.add("#request");
        set.add("#parameters");
        set.add("#session");
        set.add("#application");
        UNSAFE_VARIABLE_NAMES = Collections.unmodifiableSet(set);
    }
}

