/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.interceptor;

import com.opensymphony.xwork.Action;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.Interceptor;
import java.io.Serializable;
import java.util.Map;

public class ExecuteAndWaitInterceptor
implements Interceptor {
    public static final String KEY = "__execWait";

    public void destroy() {
    }

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String intercept(ActionInvocation actionInvocation) throws Exception {
        Map session;
        String name = actionInvocation.getProxy().getActionName();
        Map map = session = actionInvocation.getInvocationContext().getSession();
        synchronized (map) {
            BackgroundProcess bp = (BackgroundProcess)session.get(KEY + name);
            if (bp == null) {
                bp = new BackgroundProcess(actionInvocation);
                session.put(KEY + name, bp);
            }
            if (!bp.isDone()) {
                actionInvocation.getStack().push((Object)bp.getAction());
                return "wait";
            }
            session.remove(KEY + name);
            actionInvocation.getStack().push((Object)bp.getAction());
            return bp.getResult();
        }
    }

    static class BackgroundProcess
    implements Serializable {
        private Action action;
        private ActionInvocation invocation;
        private String result;
        private boolean done;

        public BackgroundProcess(ActionInvocation invocation) {
            this.invocation = invocation;
            this.action = invocation.getAction();
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        BackgroundProcess.this.result = BackgroundProcess.this.action.execute();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    BackgroundProcess.this.done = true;
                }
            });
            t.start();
        }

        public Action getAction() {
            return this.action;
        }

        public String getResult() {
            return this.result;
        }

        public boolean isDone() {
            return this.done;
        }
    }
}

