/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher.client;

import com.opensymphony.webwork.dispatcher.client.ClientException;
import com.opensymphony.webwork.dispatcher.client.ProgressConsumer;
import com.opensymphony.webwork.dispatcher.client.ProgressNotification;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Properties;

public class ProgressOutputStream
extends FilterOutputStream {
    private ProgressConsumer progressConsumer;
    private ProgressNotification notification;
    private int lastNotificationStatus;
    private int nwritten = 0;
    private int size = 0;
    private long lastUpdate;
    private long updateFrequency;

    public ProgressOutputStream(ProgressNotification notification, ProgressConsumer progressConsumer, Properties props, OutputStream out, int contentLength) {
        super(out);
        this.size = contentLength;
        this.notification = notification;
        this.progressConsumer = progressConsumer;
        this.lastUpdate = new Date().getTime();
        this.lastNotificationStatus = notification.getStatus();
        notification.setOutputSize(this.size);
        try {
            this.updateFrequency = new Long(props.getProperty("updateFrequency", "250"));
        }
        catch (NumberFormatException nfe) {
            this.updateFrequency = 500L;
        }
        try {
            notification.setStatus(2);
        }
        catch (ClientException clientException) {
            // empty catch block
        }
        this.updateBytes(this.nwritten);
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.updateBytes(this.nwritten);
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
        this.updateBytes(this.nwritten);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.nwritten;
        this.updateBytes(this.nwritten);
    }

    @Override
    public void write(byte[] b) throws IOException {
        int length = b.length;
        this.out.write(b);
        if (length > 0) {
            this.nwritten += length;
            this.updateBytes(this.nwritten);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if ((off | len | b.length - (len + off) | off + len) < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.write(b[off + i]);
        }
    }

    private void updateBytes(int nowWritten) {
        boolean update = false;
        if (nowWritten >= this.size && this.notification.getStatus() == 2) {
            try {
                this.notification.setStatus(3);
            }
            catch (ClientException clientException) {
                // empty catch block
            }
        }
        if (this.lastNotificationStatus != this.notification.getStatus()) {
            update = true;
        }
        long currentTime = new Date().getTime();
        if (this.notification.getStatus() == 2 && currentTime > this.lastUpdate + this.updateFrequency) {
            update = true;
        }
        if (update) {
            this.lastUpdate = currentTime;
            this.lastNotificationStatus = this.notification.getStatus();
            this.notification.setOutputTransmitted(nowWritten);
            this.progressConsumer.notify(this.notification);
        }
    }
}

