/*
 * Copyright (c) 2002-2003 by OpenSymphony
 * All rights reserved.
 */
package com.opensymphony.webwork.views.jsp.ui;

import com.opensymphony.xwork.util.OgnlValueStack;


/**
 * @author Matt Ho <a href="mailto:matt@enginegreen.com">&lt;matt@enginegreen.com&gt;</a>
 * @version $Id: CheckboxTag.java 557 2004-10-18 03:43:56Z plightbo $
 */
public class CheckboxTag extends AbstractUITag {
    //~ Static fields/initializers /////////////////////////////////////////////

    /**
     * The name of the default template for the CheckboxTag
     */
    final public static String TEMPLATE = "checkbox";

    //~ Instance fields ////////////////////////////////////////////////////////

    protected String fieldValueAttr;

    //~ Methods ////////////////////////////////////////////////////////////////

    public void setFieldValue(String aValue) {
        this.fieldValueAttr = aValue;
    }

    protected String getDefaultTemplate() {
        return TEMPLATE;
    }

    protected Class getValueClassType() {
        return Boolean.class; // for checkboxes, everything needs to end up as a Boolean
    }

    protected void evaluateExtraParams(OgnlValueStack stack) {
        if (fieldValueAttr != null) {
            addParameter("fieldValue", findString(fieldValueAttr));
        }
    }
}
