/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher.client;

import com.opensymphony.util.FileManager;
import com.opensymphony.webwork.WebWorkStatics;
import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.dispatcher.ApplicationMap;
import com.opensymphony.webwork.dispatcher.SessionMap;
import com.opensymphony.webwork.dispatcher.client.ClientRequestInvocation;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequest;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequestWrapper;
import com.opensymphony.xwork.ActionProxy;
import com.opensymphony.xwork.ActionProxyFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServerHttpDispatcher
extends HttpServlet
implements WebWorkStatics {
    protected static final Log log = LogFactory.getLog(ServerHttpDispatcher.class);
    Integer maxSize;
    String saveDir;

    public static String getNamespaceFromServletPath(String servletPath) {
        servletPath = servletPath.substring(0, servletPath.lastIndexOf("/"));
        return servletPath;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if ("true".equalsIgnoreCase(Configuration.getString("webwork.configuration.xml.reload"))) {
            FileManager.setReloadingConfigs((boolean)true);
        }
        this.saveDir = Configuration.getString("webwork.multipart.saveDir").trim();
        if (this.saveDir.equals("")) {
            File tempdir = (File)config.getServletContext().getAttribute("javax.servlet.context.tempdir");
            log.warn((Object)"Unable to find 'webwork.multipart.saveDir' property setting. Defaulting to javax.servlet.context.tempdir");
            if (tempdir != null) {
                this.saveDir = tempdir.toString();
            }
        } else {
            File multipartSaveDir = new File(this.saveDir);
            if (!multipartSaveDir.exists()) {
                multipartSaveDir.mkdir();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("saveDir=" + this.saveDir));
        }
        try {
            String maxSizeStr = Configuration.getString("webwork.multipart.maxSize");
            if (maxSizeStr != null) {
                try {
                    this.maxSize = new Integer(maxSizeStr);
                }
                catch (NumberFormatException e) {
                    this.maxSize = new Integer(Integer.MAX_VALUE);
                    log.warn((Object)"Unable to format 'webwork.multipart.maxSize' property setting. Defaulting to Integer.MAX_VALUE");
                }
            } else {
                this.maxSize = new Integer(Integer.MAX_VALUE);
                log.warn((Object)"Unable to format 'webwork.multipart.maxSize' property setting. Defaulting to Integer.MAX_VALUE");
            }
        }
        catch (IllegalArgumentException e1) {
            this.maxSize = new Integer(Integer.MAX_VALUE);
            log.warn((Object)"Unable to format 'webwork.multipart.maxSize' property setting. Defaulting to Integer.MAX_VALUE");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("maxSize=" + this.maxSize));
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ClientRequestInvocation invocation;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Servicing request");
        }
        try {
            request = this.wrapRequest(request);
        }
        catch (IOException e) {
            String message = "Could not wrap servlet request with MultipartRequestWrapper!";
            log.error((Object)message, (Throwable)e);
            throw new ServletException(message, (Throwable)e);
        }
        String servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = request.getServletPath();
        }
        ObjectInputStream in = new ObjectInputStream((InputStream)request.getInputStream());
        try {
            invocation = (ClientRequestInvocation)in.readObject();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Have a ClientRequestInvocation object");
            }
        }
        catch (ClassNotFoundException cnfe) {
            String message = "Could not deserialise ClientActionInvocation!";
            log.error((Object)message, (Throwable)cnfe);
            throw new ServletException(message, (Throwable)cnfe);
        }
        String actionName = this.getActionName(invocation.getRemoteActionName());
        String actionPath = ServerHttpDispatcher.getNamespaceFromServletPath(invocation.getRemoteActionName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Executing action: " + actionName + " with namespace: " + actionPath));
        }
        HashMap<String, Object> extraContext = new HashMap<String, Object>();
        extraContext.put("com.opensymphony.xwork.ActionContext.parameters", invocation.getParameters());
        extraContext.put("com.opensymphony.xwork.ActionContext.session", new SessionMap(request));
        extraContext.put("com.opensymphony.xwork.ActionContext.application", new ApplicationMap(this.getServletContext()));
        extraContext.put("com.opensymphony.xwork.dispatcher.HttpServletRequest", request);
        extraContext.put("com.opensymphony.xwork.dispatcher.HttpServletResponse", response);
        extraContext.put("com.opensymphony.xwork.dispatcher.ServletConfig", this.getServletConfig());
        extraContext.put("com.opensymphony.xwork.interceptor.component.ComponentManager", request.getAttribute("DefaultComponentManager"));
        extraContext.put("com.opensymphony.xwork.dispatcher.ServletDispatcher", this);
        try {
            ActionProxy proxy = ActionProxyFactory.getFactory().createActionProxy(actionPath, actionName, extraContext);
            request.setAttribute("webwork.valueStack", (Object)proxy.getInvocation().getStack());
            proxy.execute();
        }
        catch (Exception e) {
            try {
                response.setContentType("text/html");
                response.setLocale(Configuration.getLocale());
                PrintWriter writer = response.getWriter();
                writer.write("Error executing action: " + e.getMessage());
                writer.println("<pre>\n");
                e.printStackTrace(response.getWriter());
                writer.print("</pre>\n");
                log.error((Object)"Could not execute action", (Throwable)e);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    String getActionName(String name) {
        int beginIdx = name.lastIndexOf("/");
        int endIdx = name.lastIndexOf(".");
        return name.substring(beginIdx == -1 ? 0 : beginIdx + 1, endIdx == -1 ? name.length() : endIdx);
    }

    private HttpServletRequest wrapRequest(HttpServletRequest request) throws IOException {
        if (request instanceof MultiPartRequestWrapper) {
            return request;
        }
        if (MultiPartRequest.isMultiPart(request)) {
            request = new MultiPartRequestWrapper((HttpServletRequest)request, this.saveDir, this.maxSize);
        }
        return request;
    }
}

