/*
 * Copyright (c) 2002-2003 by OpenSymphony
 * All rights reserved.
 */
package com.opensymphony.webwork.views.velocity;

import com.opensymphony.xwork.util.OgnlValueStack;
import org.apache.velocity.VelocityContext;


/**
 * @author $Author: jcarreira $
 * @version $Revision: 537 $
 */
public class WebWorkVelocityContext extends VelocityContext {
    //~ Instance fields ////////////////////////////////////////////////////////

    OgnlValueStack stack;
    VelocityContext[] chainedContexts;

    //~ Constructors ///////////////////////////////////////////////////////////

    public WebWorkVelocityContext(OgnlValueStack stack) {
        this(null, stack);
    }

    public WebWorkVelocityContext(VelocityContext[] chainedContexts, OgnlValueStack stack) {
        this.chainedContexts = chainedContexts;
        this.stack = stack;
    }

    //~ Methods ////////////////////////////////////////////////////////////////

    public boolean internalContainsKey(Object key) {
        return internalGet(key.toString()) != null;
    }

    public Object internalGet(String key) {
        Object value;

        value = super.internalGet(key);
        if (value != null) {
            return value;
        }

        if (chainedContexts != null) {
            for (VelocityContext chainedContext : chainedContexts) {
                value =  chainedContext.internalGet(key);
                if (value != null) {
                    return value;
                }
            }
        }

        if (stack != null) {
            value = stack.findValue(key);
            if (value != null) {
                return value;
            }
        }

        return null;
    }
}
