/*
 * Decompiled with CFR 0.152.
 */
package webwork.util.classloader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import webwork.util.ClassLoaderUtils;
import webwork.util.classloader.BytesURLStreamHandler;
import webwork.util.classloader.WebworkClassLoader;

public class DirectoryClassLoader
extends WebworkClassLoader {
    private File directory;
    private HashMap timestamps = new HashMap();

    public DirectoryClassLoader(File file, ClassLoader parent) {
        super(parent);
        this.directory = file;
    }

    public boolean isStale() {
        Iterator iter = ((Map)this.timestamps.clone()).entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            File toCheck = (File)entry.getKey();
            long time = (Long)entry.getValue();
            if (toCheck.lastModified() <= time) continue;
            return true;
        }
        return false;
    }

    protected URL getDataURL(String name, byte[] data) throws MalformedURLException {
        return new URL(null, this.directory.toURL().toExternalForm() + '/' + name, new BytesURLStreamHandler(data));
    }

    public byte[] getFile(String path) {
        try {
            File file = new File(this.directory, path);
            if (!file.exists()) {
                return null;
            }
            int size = (int)file.length();
            FileInputStream in = new FileInputStream(file);
            this.timestamps.put(file, new Long(file.lastModified()));
            return ClassLoaderUtils.readStream(in, size);
        }
        catch (IOException e) {
            return null;
        }
    }

    public Object clone() {
        DirectoryClassLoader loader = new DirectoryClassLoader(this.directory, this.getParent());
        loader.packages = this.packages;
        return loader;
    }
}

