/*
 * Decompiled with CFR 0.152.
 */
package webwork.config.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import webwork.config.Configuration;

public class XMLConfigurationReader {
    public static final Log log = LogFactory.getLog((Class)(class$webwork$config$util$XMLConfigurationReader == null ? (class$webwork$config$util$XMLConfigurationReader = XMLConfigurationReader.class$("webwork.config.util.XMLConfigurationReader")) : class$webwork$config$util$XMLConfigurationReader));
    private final Map actionMappings;
    private static final String EXTENSION_PROPERTY = "webwork.action.extension";
    static /* synthetic */ Class class$webwork$config$util$XMLConfigurationReader;

    public XMLConfigurationReader(Element configurationRootElement) {
        this.actionMappings = this.getMappingsFromDocument(configurationRootElement);
    }

    public Object getActionMapping(String mappingName) {
        return this.actionMappings.get(this.replaceExtension(mappingName));
    }

    public Set getActionMappingNames() {
        return this.actionMappings.keySet();
    }

    private Map getMappingsFromDocument(Element element) {
        HashMap<String, String> actionMap = new HashMap<String, String>();
        NodeList actions = element.getElementsByTagName("action");
        int length = actions.getLength();
        for (int i = 0; i < length; ++i) {
            Element view;
            int j;
            Element action = (Element)actions.item(i);
            String actionName = action.getAttribute("name");
            String actionAlias = action.getAttribute("alias");
            NodeList views = action.getElementsByTagName("view");
            for (j = 0; j < views.getLength() && (view = (Element)views.item(j)).getParentNode().equals(action); ++j) {
                String actionViewName;
                NodeList viewMapping = view.getChildNodes();
                StringBuffer mapping = new StringBuffer();
                for (int k = 0; k < viewMapping.getLength(); ++k) {
                    Node mappingNode = viewMapping.item(k);
                    if (!(mappingNode instanceof Text)) continue;
                    mapping.append(mappingNode.getNodeValue());
                }
                if ("".equals(actionAlias)) {
                    actionViewName = !"".equals(actionName) ? actionName + "." + view.getAttribute("name") : view.getAttribute("name");
                } else {
                    actionViewName = actionAlias + "." + view.getAttribute("name");
                    log.debug((Object)("Adding action alias " + actionAlias + "=" + actionName));
                    actionMap.put(actionAlias + ".action", actionName);
                }
                String actionViewMapping = mapping.toString().trim();
                log.debug((Object)("Adding view mapping " + actionViewName + "=" + actionViewMapping));
                actionMap.put(actionViewName, actionViewMapping);
            }
            NodeList commands = action.getElementsByTagName("command");
            for (j = 0; j < commands.getLength(); ++j) {
                Element command = (Element)commands.item(j);
                String commandName = command.getAttribute("name");
                String commandAlias = command.getAttribute("alias");
                if (!commandAlias.equals("")) {
                    log.debug((Object)("Adding command alias " + commandAlias + "=" + actionName + "!" + commandName));
                    actionMap.put(commandAlias + ".action", actionName + "!" + commandName);
                }
                NodeList views2 = command.getElementsByTagName("view");
                for (int k = 0; k < views2.getLength(); ++k) {
                    Element view2 = (Element)views2.item(k);
                    NodeList viewMapping = view2.getChildNodes();
                    StringBuffer mapping = new StringBuffer();
                    for (int l = 0; l < viewMapping.getLength(); ++l) {
                        Node mappingNode = viewMapping.item(l);
                        if (!(mappingNode instanceof Text)) continue;
                        mapping.append(mappingNode.getNodeValue());
                    }
                    String commandViewName = commandAlias.equals("") ? (actionAlias.equals("") ? actionName + "!" + commandName + "." + view2.getAttribute("name") : actionAlias + "!" + commandName + "." + view2.getAttribute("name")) : commandAlias + "." + view2.getAttribute("name");
                    String commandViewMapping = mapping.toString().trim();
                    log.debug((Object)("Adding command view mapping " + commandViewName + "=" + commandViewMapping));
                    actionMap.put(commandViewName, commandViewMapping);
                }
            }
        }
        return actionMap;
    }

    private String replaceExtension(String actionName) {
        if (EXTENSION_PROPERTY.equals(actionName)) {
            return actionName;
        }
        String ext = "." + Configuration.get(EXTENSION_PROPERTY);
        if (actionName != null && !".action".equals(ext)) {
            int idx;
            if (actionName.endsWith(ext)) {
                actionName = actionName.substring(0, actionName.lastIndexOf(ext)) + ".action";
            }
            if ((idx = actionName.indexOf(ext + "?")) > 0) {
                actionName = actionName.substring(0, idx) + ".action?" + actionName.substring(idx + ext.length() + 1);
            }
        }
        return actionName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

