/*
 * Decompiled with CFR 0.152.
 */
package webwork.config;

import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.logging.LogFactory;
import webwork.config.ConfigurationInterface;
import webwork.config.DefaultConfiguration;
import webwork.util.ClassLoaderUtils;

public final class Configuration {
    static ConfigurationInterface configurationImpl;
    static ConfigurationInterface defaultImpl;
    static Locale locale;
    static /* synthetic */ Class class$webwork$config$ConfigurationInterface;
    static /* synthetic */ Class class$webwork$config$Configuration;

    private Configuration() {
    }

    public static Object get(String aName) throws IllegalArgumentException {
        Object val = Configuration.getConfiguration().getImpl(aName);
        return val;
    }

    public static String getString(String aName) throws IllegalArgumentException {
        Object o = Configuration.get(aName);
        return o == null ? aName : o.toString();
    }

    public static void set(String aName, Object aValue) throws IllegalArgumentException, UnsupportedOperationException {
        Configuration.getConfiguration().setImpl(aName, aValue);
    }

    public static Iterator list() {
        return Configuration.getConfiguration().listImpl();
    }

    public static Locale getLocale() {
        if (locale == null) {
            try {
                StringTokenizer localeTokens = new StringTokenizer(Configuration.getString("webwork.locale"), "_");
                String lang = null;
                String country = null;
                if (localeTokens.hasMoreTokens()) {
                    lang = localeTokens.nextToken();
                }
                if (localeTokens.hasMoreTokens()) {
                    country = localeTokens.nextToken();
                }
                locale = new Locale(lang, country);
            }
            catch (IllegalArgumentException e) {
                locale = Locale.getDefault();
            }
        }
        return locale;
    }

    public static ConfigurationInterface getConfiguration() {
        return configurationImpl == null ? Configuration.getDefaultConfiguration() : configurationImpl;
    }

    public static void setConfiguration(ConfigurationInterface aConfig) throws IllegalStateException {
        if (configurationImpl != null) {
            throw new IllegalStateException("May only set configuration implementation once");
        }
        configurationImpl = aConfig;
        locale = null;
    }

    private static ConfigurationInterface getDefaultConfiguration() {
        if (defaultImpl == null) {
            defaultImpl = new DefaultConfiguration();
            try {
                String className = Configuration.getString("webwork.configuration");
                if (!className.equals(defaultImpl.getClass().getName())) {
                    try {
                        defaultImpl = (ConfigurationInterface)ClassLoaderUtils.loadClass(className, class$webwork$config$ConfigurationInterface == null ? (class$webwork$config$ConfigurationInterface = Configuration.class$("webwork.config.ConfigurationInterface")) : class$webwork$config$ConfigurationInterface).newInstance();
                    }
                    catch (Exception e) {
                        LogFactory.getLog((Class)(class$webwork$config$Configuration == null ? (class$webwork$config$Configuration = Configuration.class$("webwork.config.Configuration")) : class$webwork$config$Configuration)).error((Object)"Could not instantiate configuration", (Throwable)e);
                    }
                }
            }
            catch (IllegalArgumentException ex) {
                LogFactory.getLog((Class)(class$webwork$config$Configuration == null ? (class$webwork$config$Configuration = Configuration.class$("webwork.config.Configuration")) : class$webwork$config$Configuration)).error((Object)"No default configuration defined", (Throwable)ex);
            }
        }
        return defaultImpl;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

